/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.pool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.implementation.ExternalResource;
import org.jvoicexml.implementation.ResourceFactory;
import org.jvoicexml.implementation.pool.PoolableResourceFactory;

public final class KeyedResourcePool<T extends ExternalResource> {
    private static final Logger LOGGER = LogManager.getLogger(KeyedResourcePool.class);
    private final Map<String, ObjectPool<T>> pools = new HashMap<String, ObjectPool<T>>();

    public void addResourceFactory(ResourceFactory<T> resourceFactory) throws Exception {
        PoolableResourceFactory<T> factory = new PoolableResourceFactory<T>(resourceFactory);
        GenericObjectPool pool = new GenericObjectPool(factory);
        int instances = resourceFactory.getInstances();
        pool.setMinIdle(instances);
        pool.setMaxActive(instances);
        pool.setMaxIdle(instances);
        pool.setWhenExhaustedAction((byte)0);
        String type = resourceFactory.getType();
        this.pools.put(type, (ObjectPool<T>)pool);
        LOGGER.info("loading " + instances + " instance(s) of type '" + type + "'");
        for (int i = 0; i < instances; ++i) {
            pool.addObject();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...resources loaded.");
        }
    }

    public synchronized T borrowObject(Object key) throws NoresourceError {
        ExternalResource resource;
        ObjectPool<T> pool = this.pools.get(key);
        if (pool == null) {
            throw new NoresourceError("Pool of type '" + key + "' is unknown!");
        }
        try {
            resource = (ExternalResource)pool.borrowObject();
        }
        catch (NoSuchElementException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new NoresourceError(e.getMessage(), e);
        }
        LOGGER.info("borrowed object of type '" + key + "' (" + resource.getClass().getCanonicalName() + ")");
        if (LOGGER.isDebugEnabled()) {
            int active = pool.getNumActive();
            int idle = pool.getNumIdle();
            LOGGER.debug("pool has now " + active + " active/" + idle + " idle for key '" + key + "' (" + resource.getClass().getCanonicalName() + ") after borrow");
        }
        return (T)resource;
    }

    public synchronized void returnObject(String key, T resource) throws NoresourceError {
        ObjectPool<T> pool = this.pools.get(key);
        if (pool == null) {
            throw new NoresourceError("Pool of type '" + key + "' is unknown!");
        }
        try {
            pool.returnObject(resource);
        }
        catch (Exception e) {
            throw new NoresourceError(e.getMessage(), e);
        }
        LOGGER.info("returned object of type '" + key + "' (" + resource.getClass().getCanonicalName() + ")");
        if (LOGGER.isDebugEnabled()) {
            int active = pool.getNumActive();
            int idle = pool.getNumIdle();
            LOGGER.debug("pool has now " + active + " active/" + idle + " idle for key '" + key + "' (" + resource.getClass().getCanonicalName() + ") after return");
        }
    }

    public synchronized int getNumActive() {
        int active = 0;
        Collection<ObjectPool<T>> col = this.pools.values();
        for (ObjectPool<T> pool : col) {
            active += pool.getNumActive();
        }
        return active;
    }

    public synchronized int getNumActive(String key) {
        ObjectPool<T> pool = this.pools.get(key);
        return pool.getNumActive();
    }

    public synchronized int getNumIdle() {
        int idle = 0;
        Collection<ObjectPool<T>> col = this.pools.values();
        for (ObjectPool<T> pool : col) {
            idle += pool.getNumIdle();
        }
        return idle;
    }

    public synchronized int getNumIdle(String key) {
        ObjectPool<T> pool = this.pools.get(key);
        if (pool == null) {
            return -1;
        }
        return pool.getNumIdle();
    }

    public Collection<String> getKeys() {
        return this.pools.keySet();
    }

    public synchronized void close() throws Exception {
        Collection<ObjectPool<T>> col = this.pools.values();
        for (ObjectPool<T> pool : col) {
            pool.close();
        }
    }
}

