/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.pool;

import org.apache.commons.pool.PoolableObjectFactory;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.implementation.ExternalResource;
import org.jvoicexml.implementation.ResourceFactory;

final class PoolableResourceFactory<T extends ExternalResource>
implements PoolableObjectFactory<T> {
    private final ResourceFactory<T> factory;

    PoolableResourceFactory(ResourceFactory<T> resourceFactory) {
        this.factory = resourceFactory;
    }

    public T makeObject() throws Exception {
        T resource;
        try {
            resource = this.factory.createResource();
            resource.open();
        }
        catch (NoresourceError e) {
            throw new Exception("error creating resource of type " + this.factory.getType() + ": " + e.getMessage(), e);
        }
        return resource;
    }

    public void destroyObject(T resource) throws Exception {
        resource.close();
    }

    public boolean validateObject(T object) {
        return false;
    }

    public void activateObject(T resource) throws Exception {
        try {
            resource.activate();
        }
        catch (NoresourceError e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public void passivateObject(T resource) throws Exception {
        try {
            resource.passivate();
        }
        catch (NoresourceError e) {
            throw new Exception(e.getMessage(), e);
        }
    }
}

