/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.interpreter.ActiveGrammarSetObserver;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopedSet;
import org.jvoicexml.interpreter.scope.ScopedSetObserver;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;

public class ActiveGrammarSet
implements ScopedSetObserver<GrammarDocument> {
    private static final Logger LOGGER = LogManager.getLogger(ActiveGrammarSet.class);
    private final ScopedSet<GrammarDocument> grammars;
    private final Collection<ActiveGrammarSetObserver> observers = new ArrayList<ActiveGrammarSetObserver>();

    public ActiveGrammarSet(ScopeObserver scopeObserver) {
        this.grammars = new ScopedSet(scopeObserver);
        this.grammars.addScopedSetObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveGrammarSetObserver(ActiveGrammarSetObserver obs) {
        Collection<ActiveGrammarSetObserver> collection = this.observers;
        synchronized (collection) {
            this.observers.add(obs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveGrammarSetObserver(ActiveGrammarSetObserver obs) {
        Collection<ActiveGrammarSetObserver> collection = this.observers;
        synchronized (collection) {
            this.observers.remove(obs);
        }
    }

    public int size() {
        return this.grammars.size();
    }

    public void add(GrammarDocument grammar) {
        this.grammars.add(grammar);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added 1 grammar - now containing " + this.grammars.size());
        }
    }

    public void addAll(Collection<GrammarDocument> grams) {
        this.grammars.addAll(grams);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added " + grams.size() + " grammar(s) - now containing " + this.grammars.size());
        }
    }

    public void removeAll(Collection<GrammarDocument> grams) {
        this.grammars.removeAll(grams);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("removed " + grams.size() + " grammar(s) - now containing " + this.grammars.size());
        }
    }

    public boolean contains(GrammarDocument document) {
        return this.grammars.contains(document);
    }

    public Collection<GrammarDocument> getGrammars() {
        return this.grammars;
    }

    public Collection<GrammarType> getGrammarTypes() {
        HashSet<GrammarType> types = new HashSet<GrammarType>();
        for (GrammarDocument document : this.grammars) {
            GrammarType type = document.getMediaType();
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    public Collection<ModeType> getModeTypes() {
        HashSet<ModeType> types = new HashSet<ModeType>();
        for (GrammarDocument document : this.grammars) {
            ModeType type = document.getModeType();
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scopedSetChange(ScopedSet<GrammarDocument> set, Collection<GrammarDocument> removed) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("removed " + removed.size() + " grammars - " + this.grammars.size() + " grammars remaining");
        }
        Collection<ActiveGrammarSetObserver> collection = this.observers;
        synchronized (collection) {
            for (ActiveGrammarSetObserver obs : this.observers) {
                obs.removedGrammars(this, removed);
            }
        }
    }
}

