/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Application;
import org.jvoicexml.CallControl;
import org.jvoicexml.CallControlProperties;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.DocumentDescriptor;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.DtmfRecognizerProperties;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.Session;
import org.jvoicexml.SpeechRecognizerProperties;
import org.jvoicexml.UserInput;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.error.UnsupportedFormatError;
import org.jvoicexml.event.error.UnsupportedLanguageError;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;
import org.jvoicexml.event.plain.implementation.RecordingStartedEvent;
import org.jvoicexml.event.plain.jvxml.GotoNextFormEvent;
import org.jvoicexml.event.plain.jvxml.GotoNextFormItemEvent;
import org.jvoicexml.event.plain.jvxml.InternalExitEvent;
import org.jvoicexml.interpreter.ActiveGrammarSet;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.EventHandler;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.FormItemLocalExecutableTagContainer;
import org.jvoicexml.interpreter.FormItemVisitor;
import org.jvoicexml.interpreter.GrammarContainer;
import org.jvoicexml.interpreter.GrammarProcessor;
import org.jvoicexml.interpreter.InputItem;
import org.jvoicexml.interpreter.InterpreterState;
import org.jvoicexml.interpreter.JVoiceXmlSession;
import org.jvoicexml.interpreter.ObjectExecutorThread;
import org.jvoicexml.interpreter.ParamParser;
import org.jvoicexml.interpreter.PromptChooser;
import org.jvoicexml.interpreter.PromptCountable;
import org.jvoicexml.interpreter.RecordingReceiverThread;
import org.jvoicexml.interpreter.SubdialogExecutorThread;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.BlockFormItem;
import org.jvoicexml.interpreter.formitem.FieldFormItem;
import org.jvoicexml.interpreter.formitem.InitialFormItem;
import org.jvoicexml.interpreter.formitem.ObjectFormItem;
import org.jvoicexml.interpreter.formitem.OptionConverter;
import org.jvoicexml.interpreter.formitem.RecordFormItem;
import org.jvoicexml.interpreter.formitem.SubdialogFormItem;
import org.jvoicexml.interpreter.formitem.TransferFormItem;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.profile.Profile;
import org.jvoicexml.profile.TagStrategy;
import org.jvoicexml.profile.TagStrategyExecutor;
import org.jvoicexml.profile.TagStrategyFactory;
import org.jvoicexml.xml.TimeParser;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.w3c.dom.Node;

public final class FormInterpretationAlgorithm
implements FormItemVisitor {
    private static final Logger LOGGER = LogManager.getLogger(FormInterpretationAlgorithm.class);
    private static final int DEFAULT_PROMPT_TIMEOUT = 30000;
    private static final int DEFAULT_RECORDING_MAXTIME = 30000;
    private final Dialog dialog;
    private final String id;
    private final Collection<FormItem> formItems;
    private final Map<String, FormItem> formItemMap;
    private FormItem item;
    private final VoiceXmlInterpreterContext context;
    private final VoiceXmlInterpreter interpreter;
    private Profile profile;
    private TagStrategyExecutor executor;
    private boolean reprompt;
    private boolean activeDialogChanged;
    private final Set<InputItem> justFilled;
    private Collection<EventStrategy> eventStrategies;
    private final Set<GrammarDocument> localGrammars;
    private final Map<String, String> localProperties;
    private boolean queuingPrompts;

    public FormInterpretationAlgorithm(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter ip, Dialog currentDialog) {
        this.context = ctx;
        this.interpreter = ip;
        this.dialog = currentDialog;
        this.formItems = new ArrayList<FormItem>();
        this.formItemMap = new HashMap<String, FormItem>();
        this.id = this.dialog.getId();
        this.justFilled = new LinkedHashSet<InputItem>();
        this.localGrammars = new HashSet<GrammarDocument>();
        this.localProperties = new HashMap<String, String>();
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public VoiceXmlInterpreterContext getVoiceXmlInterpreterContext() {
        return this.context;
    }

    public TagStrategyExecutor getTagStrategyExecutor() {
        return this.executor;
    }

    public void initialize(Profile prof, Map<String, Object> parameters) throws JVoiceXMLEvent {
        this.profile = prof;
        if (this.profile == null) {
            throw new BadFetchError("No profile given. Unable to initialize form '" + this.id + "'");
        }
        this.executor = new TagStrategyExecutor(this.profile);
        LOGGER.info("initializing FIA for dialog '" + this.id + "' using profile '" + this.profile.getName() + "'...");
        this.reprompt = false;
        this.activeDialogChanged = true;
        this.formItems.clear();
        this.formItemMap.clear();
        Collection<FormItem> dialogItems = this.dialog.getFormItems(this.context);
        for (FormItem current : dialogItems) {
            this.initFormItem(current);
        }
        DataModel model = this.context.getDataModel();
        Collection<XmlNode> children = this.dialog.getChildNodes();
        this.initializeNodes(model, children);
        if (parameters != null) {
            this.updateParameters(parameters, model);
        }
        int elements = this.formItems.size();
        LOGGER.info("found " + elements + " form items in dialog '" + this.id + "'...");
    }

    private void initializeNodes(DataModel model, Collection<? extends XmlNode> nodes) throws SemanticError, ErrorEvent, JVoiceXMLEvent {
        TagStrategyFactory factory = this.profile.getInitializationTagStrategyFactory();
        for (XmlNode xmlNode : nodes) {
            VoiceXmlNode node;
            TagStrategy strategy;
            if (!(xmlNode instanceof VoiceXmlNode) || (strategy = factory.getTagStrategy((Node)(node = (VoiceXmlNode)xmlNode))) == null) continue;
            strategy.getAttributes(this.context, this, node);
            strategy.evalAttributes(this.context);
            if (LOGGER.isDebugEnabled()) {
                strategy.dumpNode(model, node);
            }
            strategy.validateAttributes(model);
            strategy.execute(this.context, this.interpreter, this, null, node);
        }
    }

    private void updateParameters(Map<String, Object> parameters, DataModel model) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("updating parameters...");
        }
        for (String name : parameters.keySet()) {
            Object value;
            int rc = model.updateVariable(name, value = parameters.get(name));
            if (rc == 0) continue;
            throw new SemanticError("Parameter '" + name + "' has not been defined!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...updated parameters");
        }
    }

    private void initFormItem(FormItem formItem) throws SemanticError, BadFetchError {
        String name = formItem.getName();
        this.formItems.add(formItem);
        FormItem previousItem = this.formItemMap.put(name, formItem);
        if (previousItem != null) {
            throw new BadFetchError("Duplicate form item name '" + name + "'");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("initializing form item '" + name + "'");
        }
        DataModel model = this.context.getDataModel();
        formItem.init(model);
        if (formItem instanceof FieldFormItem) {
            Configuration configuration = this.context.getConfiguration();
            try {
                OptionConverter converter = configuration.loadObject(OptionConverter.class);
                FieldFormItem fieldFormItem = (FieldFormItem)formItem;
                fieldFormItem.setOptionConverter(converter);
            }
            catch (ConfigurationException e) {
                throw new BadFetchError(e.getMessage(), e);
            }
        }
    }

    public FormItem getFormItem(String name) {
        return this.formItemMap.get(name);
    }

    public Collection<FormItem> getFormItems() {
        return this.formItems;
    }

    public FormItem getFormItem() {
        return this.item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainLoop() throws JVoiceXMLEvent {
        LOGGER.info("starting main loop for form '" + this.id + "'...");
        String lastFormItem = null;
        String gotoFormItemName = null;
        do {
            this.item = this.select(gotoFormItemName);
            gotoFormItemName = null;
            if (this.item == null) continue;
            String name = this.item.getName();
            LOGGER.info("next form item in form '" + this.id + "' is '" + name + "'");
            this.activeDialogChanged = !name.equals(lastFormItem);
            lastFormItem = name;
            try {
                VoiceXmlNode node = this.item.getNode();
                Collection children = node.getChildren();
                DataModel model = this.context.getDataModel();
                this.initializeNodes(model, children);
                this.interpreter.setState(InterpreterState.WAITING);
                this.collect(this.item);
                this.process(this.item);
            }
            catch (InternalExitEvent e) {
                LOGGER.info("exiting...");
                break;
            }
            catch (GotoNextFormEvent e) {
                LOGGER.info("going to form '" + e.getForm() + "'...");
                throw e;
            }
            catch (GotoNextFormItemEvent e) {
                gotoFormItemName = e.getItem();
                LOGGER.info("going to form item '" + gotoFormItemName + "'...");
            }
            catch (JVoiceXMLEvent e) {
                try {
                    LOGGER.debug("caught JVoiceXML event while processing '" + e.getEventType() + "'");
                    EventBus eventbus = this.context.getEventBus();
                    eventbus.publish(e);
                    this.processEvent(e);
                }
                catch (GotoNextFormItemEvent ie) {
                    gotoFormItemName = ie.getItem();
                    LOGGER.info("going to form item '" + gotoFormItemName + "'...");
                }
                finally {
                    EventHandler handler = this.context.getEventHandler();
                    handler.clean(this.item);
                }
            }
        } while (this.item != null);
        LOGGER.info("no next element in dialog '" + this.id + "'. Exiting mainLoop...");
    }

    private void deactivateLocalGrammars() throws UnsupportedLanguageError, BadFetchError, NoresourceError, ConnectionDisconnectHangupEvent {
        if (this.localGrammars.isEmpty()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deactivating local grammars...");
        }
        this.deactivateGrammars(this.localGrammars);
        ActiveGrammarSet activeGrammars = this.context.getActiveGrammarSet();
        activeGrammars.removeAll(this.localGrammars);
        this.localGrammars.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...local grammars deactivated");
        }
    }

    void processEvent(JVoiceXMLEvent event) throws JVoiceXMLEvent {
        InputItem inputItem = this.item instanceof InputItem ? (InputItem)this.item : null;
        EventHandler handler = this.context.getEventHandler();
        handler.processEvent(inputItem);
    }

    private FormItem select(String name) throws SemanticError, BadFetchError {
        LOGGER.info("selecting next form item in dialog '" + this.id + "'...");
        if (name != null) {
            FormItem formItem = this.getFormItem(name);
            if (formItem == null) {
                throw new BadFetchError("unable to find form item '" + name + "'");
            }
            return formItem;
        }
        for (FormItem formItem : this.formItems) {
            if (!formItem.isSelectable()) continue;
            return formItem;
        }
        return null;
    }

    private void collect(FormItem formItem) throws JVoiceXMLEvent {
        if (formItem == null) {
            LOGGER.warn("no item given: cannot collect.");
            return;
        }
        LOGGER.info("collecting '" + formItem.getName() + "'...");
        EventHandler handler = this.context.getEventHandler();
        handler.clearEvent();
        if ((this.reprompt || this.activeDialogChanged) && formItem instanceof PromptCountable) {
            PromptCountable countable = (PromptCountable)((Object)formItem);
            this.queuePrompts(formItem, countable);
            countable.incrementPromptCount();
        }
        this.reprompt = false;
        this.activeDialogChanged = false;
        this.eventStrategies = null;
        this.executeLocalTags(formItem);
        if (formItem.isModal()) {
            this.activateModalGrammars(formItem);
        } else {
            this.activateGrammars(formItem);
        }
        formItem.accept(this);
    }

    private void process(FormItem formItem) throws JVoiceXMLEvent {
        CallControl call;
        ImplementationPlatform platform;
        boolean hasUserInput;
        this.interpreter.setState(InterpreterState.TRANSITIONING);
        LOGGER.info("processing '" + formItem.getName() + "'...");
        this.justFilled.clear();
        LOGGER.info("cleared all just_filled flags");
        EventHandler handler = this.context.getEventHandler();
        boolean isInputItem = formItem instanceof InputItem;
        boolean isInitialItem = formItem instanceof InitialFormItem;
        if ((isInputItem || isInitialItem) && !this.interpreter.isInFinalProcessingState()) {
            this.interpreter.setState(InterpreterState.WAITING);
            handler.waitEvent();
        }
        if (hasUserInput = (platform = this.context.getImplementationPlatform()).isUserInputActive()) {
            UserInput userInput = platform.getUserInput();
            ActiveGrammarSet activeGrammars = this.context.getActiveGrammarSet();
            Collection<ModeType> types = activeGrammars.getModeTypes();
            userInput.stopRecognition(types);
        }
        if ((call = platform.getCallControl()) != null) {
            platform.waitNonBargeInPlayed();
            call.stopPlay();
            call.stopRecord();
        }
        if (isInputItem || isInitialItem) {
            CatchContainer container = (CatchContainer)formItem;
            handler.processEvent(container);
            handler.removeStrategies(this.eventStrategies);
        }
        if (this.reprompt) {
            LOGGER.info("reprompt: clearing all just filled elements");
            DataModel model = this.context.getDataModel();
            for (InputItem input : this.justFilled) {
                String name = input.getName();
                model.deleteVariable(name);
            }
        }
    }

    private void executeLocalTags(FormItem formItem) throws JVoiceXMLEvent {
        if (!(formItem instanceof FormItemLocalExecutableTagContainer)) {
            return;
        }
        this.localProperties.clear();
        FormItemLocalExecutableTagContainer container = (FormItemLocalExecutableTagContainer)((Object)formItem);
        this.executor.executeChildNodesLocal(this.context, this.interpreter, this, formItem, container);
    }

    public void setJustFilled(InputItem input) {
        this.justFilled.add(input);
        LOGGER.info("set just_filled flag for '" + input.getName() + "'");
    }

    public boolean isJustFilled(InputItem input) {
        return this.justFilled.contains(input);
    }

    private void queuePrompts(FormItem formItem, PromptCountable countable) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("queuing prompts...");
        }
        this.queuingPrompts = true;
        PromptChooser promptChooser = new PromptChooser(countable, this.context);
        Collection<VoiceXmlNode> prompts = promptChooser.collect();
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        long timeout = this.getPromptTimeout();
        platform.setPromptTimeout(timeout);
        for (VoiceXmlNode node : prompts) {
            this.executor.executeTagStrategy(this.context, this.interpreter, this, formItem, node);
        }
        DocumentServer server = this.context.getDocumentServer();
        Session session = this.context.getSession();
        String sessionId = session.getSessionId();
        try {
            CallControlProperties callProps = this.context.getCallControlProperties(this);
            platform.renderPrompts(sessionId, server, callProps);
        }
        catch (ConfigurationException ex) {
            throw new NoresourceError(ex.getMessage(), ex);
        }
        this.queuingPrompts = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...queued prompts");
        }
    }

    public boolean isQueuingPrompts() {
        return this.queuingPrompts;
    }

    private long getPromptTimeout() {
        String timeout = this.context.getProperty("timeout");
        if (timeout == null) {
            return 30000L;
        }
        TimeParser timeParser = new TimeParser(timeout);
        return timeParser.parse();
    }

    public GrammarDocument processGrammar(Grammar grammar) throws UnsupportedFormatError, NoresourceError, BadFetchError, SemanticError {
        GrammarProcessor processor = this.context.getGrammarProcessor();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("preprocessing grammar " + grammar + "...");
        }
        Locale language = this.interpreter.getLanguage();
        return processor.process(this.context, null, grammar, language);
    }

    private Collection<GrammarDocument> processGrammars(GrammarContainer grammarContainer, Collection<Grammar> grammars) throws UnsupportedFormatError, NoresourceError, BadFetchError, SemanticError {
        HashSet<GrammarDocument> grammarDocuments = new HashSet<GrammarDocument>();
        Collection<GrammarDocument> documents = grammarContainer.getGrammarDocuments();
        grammarDocuments.addAll(documents);
        if (grammars.isEmpty() || grammarDocuments.size() == grammars.size()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("all grammars processed (processed=" + grammarDocuments.size() + ", grammars=" + grammars.size() + ")");
            }
            return grammarDocuments;
        }
        for (Grammar grammar : grammars) {
            GrammarDocument document = this.processGrammar(grammar);
            grammarDocuments.add(document);
            if (!document.isCacheable()) continue;
            grammarContainer.addGrammar(document);
        }
        return grammarDocuments;
    }

    private void activateModalGrammars(FormItem formItem) throws BadFetchError, ConnectionDisconnectHangupEvent, UnsupportedLanguageError, NoresourceError, UnsupportedFormatError, SemanticError {
        GrammarContainer grammarContainer;
        Collection<Grammar> grammars;
        if (!(formItem instanceof GrammarContainer)) {
            return;
        }
        this.deactivateLocalGrammars();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("activating modal grammars...");
        }
        if ((grammars = (grammarContainer = (GrammarContainer)formItem).getGrammars()).size() == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("...no modal grammars to activate");
            }
            return;
        }
        Collection<GrammarDocument> processedGrammars = this.processGrammars(grammarContainer, grammars);
        ActiveGrammarSet activeGrammars = this.context.getActiveGrammarSet();
        Collection<GrammarDocument> grammarsToDeactivate = activeGrammars.getGrammars();
        this.deactivateGrammars(grammarsToDeactivate);
        this.activateGrammars(processedGrammars);
        this.localGrammars.addAll(processedGrammars);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...modal grammars activated");
        }
    }

    private void activateGrammars(FormItem formItem) throws BadFetchError, ConnectionDisconnectHangupEvent, UnsupportedLanguageError, NoresourceError, UnsupportedFormatError, SemanticError {
        boolean isInitialItem = formItem instanceof InitialFormItem;
        boolean isGrammarContainer = formItem instanceof GrammarContainer;
        if (!isGrammarContainer && !isInitialItem) {
            return;
        }
        this.deactivateLocalGrammars();
        ActiveGrammarSet activeGrammars = this.context.getActiveGrammarSet();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("active grammars: " + activeGrammars.size());
        }
        if (isGrammarContainer) {
            GrammarContainer grammarContainer = (GrammarContainer)formItem;
            Collection<Grammar> grammars = grammarContainer.getGrammars();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("found " + grammars.size() + " grammar node(s)");
            }
            Collection<GrammarDocument> processed = this.processGrammars(grammarContainer, grammars);
            activeGrammars.addAll(processed);
            this.localGrammars.addAll(processed);
        }
        if (activeGrammars.size() == 0) {
            throw new SemanticError("No grammars defined for the input of form item '" + formItem.getName() + "'!");
        }
        Collection<GrammarDocument> documents = activeGrammars.getGrammars();
        this.activateGrammars(documents);
    }

    private void activateGrammars(Collection<GrammarDocument> grammarsToActivate) throws BadFetchError, NoresourceError, UnsupportedLanguageError, ConnectionDisconnectHangupEvent, UnsupportedFormatError {
        if (grammarsToActivate.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no grammars to activate");
            }
            return;
        }
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        UserInput input = platform.getUserInput();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("activating " + grammarsToActivate.size() + " grammar(s)...");
        }
        int num = input.activateGrammars(grammarsToActivate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("..." + num + " grammar(s) activated");
        }
    }

    private void deactivateGrammars(Collection<GrammarDocument> grammarsToDeactivate) throws BadFetchError, NoresourceError, UnsupportedLanguageError, ConnectionDisconnectHangupEvent {
        if (grammarsToDeactivate.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no grammars to deactivate");
            }
            return;
        }
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        UserInput input = platform.getUserInput();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deactivating " + grammarsToDeactivate.size() + " grammar(s)...");
        }
        input.deactivateGrammars(grammarsToDeactivate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...grammar(s) deactivated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitBlockFormItem(BlockFormItem block) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("visiting block '" + block.getName() + "'...");
        }
        this.context.enterScope(Scope.ANONYMOUS);
        block.setVisited();
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        EventBus eventbus = this.context.getEventBus();
        platform.setEventBus(eventbus);
        try {
            this.executor.executeChildNodes(this.context, this.interpreter, this, block);
        }
        finally {
            this.context.exitScope(Scope.ANONYMOUS);
        }
    }

    @Override
    public void visitFieldFormItem(InputItem field) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("visiting field '" + field.getName() + "'...");
        }
        EventHandler handler = this.context.getEventHandler();
        this.eventStrategies = handler.collect(this.context, this.interpreter, this, field);
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        EventBus eventbus = this.context.getEventBus();
        platform.setEventBus(eventbus);
        platform.waitNonBargeInPlayed();
        UserInput input = platform.getUserInput();
        CallControl call = platform.getCallControl();
        try {
            if (call != null) {
                CallControlProperties callProps = this.context.getCallControlProperties(this);
                call.record(input, callProps);
            }
            DataModel model = this.context.getDataModel();
            SpeechRecognizerProperties speech = this.context.getSpeechRecognizerProperties(this);
            DtmfRecognizerProperties dtmf = this.context.getDtmfRecognizerProperties(this);
            ActiveGrammarSet activeGrammars = this.context.getActiveGrammarSet();
            Collection<ModeType> types = activeGrammars.getModeTypes();
            input.startRecognition(model, types, speech, dtmf);
        }
        catch (ConfigurationException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BadFetchError("error recording", e);
        }
    }

    @Override
    public void visitInitialFormItem(InitialFormItem initial) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("visiting initial form item '" + initial.getName() + "'...");
        }
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        UserInput input = platform.getUserInput();
        EventHandler handler = this.context.getEventHandler();
        this.eventStrategies = handler.collect(this.context, this.interpreter, this, initial);
        EventBus eventbus = this.context.getEventBus();
        platform.setEventBus(eventbus);
        platform.waitNonBargeInPlayed();
        CallControl call = platform.getCallControl();
        if (call != null) {
            try {
                call.record(input, null);
            }
            catch (IOException e) {
                throw new BadFetchError("error recording", e);
            }
        }
        try {
            DataModel model = this.context.getDataModel();
            SpeechRecognizerProperties speech = this.context.getSpeechRecognizerProperties(this);
            DtmfRecognizerProperties dtmf = this.context.getDtmfRecognizerProperties(this);
            ActiveGrammarSet activeGrammars = this.context.getActiveGrammarSet();
            Collection<ModeType> types = activeGrammars.getModeTypes();
            input.startRecognition(model, types, speech, dtmf);
        }
        catch (ConfigurationException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
    }

    @Override
    public void visitObjectFormItem(ObjectFormItem object) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("visiting object form item '" + object.getName() + "'...");
        }
        EventHandler handler = this.context.getEventHandler();
        this.eventStrategies = handler.collect(this.context, this.interpreter, this, object);
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        EventBus eventbus = this.context.getEventBus();
        platform.setEventBus(eventbus);
        platform.waitNonBargeInPlayed();
        ObjectExecutorThread objectExecutor = new ObjectExecutorThread(this.context, object);
        objectExecutor.start();
    }

    @Override
    public void visitRecordFormItem(RecordFormItem record) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("visiting record form item '" + record.getName() + "'...");
        }
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        CallControl call = platform.getCallControl();
        UserInput input = platform.getUserInput();
        EventHandler handler = this.context.getEventHandler();
        this.eventStrategies = handler.collect(this.context, this.interpreter, this, record);
        platform.waitNonBargeInPlayed();
        long maxTime = record.getMaxtime();
        if (maxTime < 0L) {
            maxTime = 30000L;
        }
        EventBus eventbus = this.context.getEventBus();
        platform.setEventBus(eventbus);
        RecordingReceiverThread recording = new RecordingReceiverThread(eventbus, maxTime);
        Session session = this.context.getSession();
        String sessionId = session.getSessionId();
        RecordingStartedEvent started = new RecordingStartedEvent(sessionId);
        eventbus.publish(started);
        recording.start();
        OutputStream stream = recording.getOutputStream();
        try {
            call.startRecording(input, stream, null);
        }
        catch (IOException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
    }

    @Override
    public void visitSubdialogFormItem(SubdialogFormItem subdialog) throws JVoiceXMLEvent {
        URI uri;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("visiting subdialog form item '" + subdialog.getName() + "'...");
        }
        EventHandler handler = this.context.getEventHandler();
        this.eventStrategies = handler.collect(this.context, this.interpreter, this, subdialog);
        try {
            uri = subdialog.getSubdialigUri();
        }
        catch (URISyntaxException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        Application application = this.context.getApplication();
        URI resolvedUri = application.resolve(uri);
        LOGGER.info("calling subdialog '" + subdialog.getName() + "' at '" + resolvedUri + "'...");
        JVoiceXmlSession session = (JVoiceXmlSession)this.context.getSession();
        DataModel model = this.context.getDataModel();
        DocumentServer documentServer = this.context.getDocumentServer();
        ParamParser parser = new ParamParser(subdialog.getNode(), model, documentServer, session);
        Map<String, Object> parameters = parser.getParameters();
        DocumentDescriptor descriptor = new DocumentDescriptor(uri);
        descriptor.addParameters(parameters);
        VoiceXmlDocument doc = this.context.loadDocument(descriptor);
        application.addDocument(resolvedUri, doc);
        ScopeObserver observer = new ScopeObserver();
        Configuration configuration = this.context.getConfiguration();
        VoiceXmlInterpreterContext subdialogContext = new VoiceXmlInterpreterContext(session, configuration, observer);
        EventBus bus = this.context.getEventBus();
        SubdialogExecutorThread thread = new SubdialogExecutorThread(resolvedUri, subdialogContext, application, parameters, bus);
        thread.start();
    }

    @Override
    public void visitTransferFormItem(TransferFormItem transfer) throws JVoiceXMLEvent {
        ImplementationPlatform platform = this.context.getImplementationPlatform();
        CallControl call = platform.getCallControl();
        boolean bridge = transfer.isBridged();
        String dest = transfer.getDest();
        if (bridge) {
            LOGGER.warn("bridge transfer not yet implemented!");
        }
        EventHandler handler = this.context.getEventHandler();
        this.eventStrategies = handler.collect(this.context, this.interpreter, this, transfer);
        EventBus eventbus = this.context.getEventBus();
        platform.setEventBus(eventbus);
        platform.waitNonBargeInPlayed();
        call.transfer(dest);
    }

    public void setReprompt(boolean on) {
        this.reprompt = on;
    }

    public String getLocalProperty(String name) {
        return this.localProperties.get(name);
    }

    public void setLocalProperty(String name, String value) {
        this.localProperties.put(name, value);
    }

    Map<String, String> getLocalProperties() {
        return this.localProperties;
    }
}

