/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.UserInput;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;
import org.jvoicexml.interpreter.ActiveGrammarSet;
import org.jvoicexml.interpreter.ActiveGrammarSetObserver;

class GrammarDeactivator
implements ActiveGrammarSetObserver {
    private static final Logger LOGGER = LogManager.getLogger(GrammarDeactivator.class);
    private final ImplementationPlatform platform;

    public GrammarDeactivator(ImplementationPlatform ip) {
        this.platform = ip;
    }

    @Override
    public void removedGrammars(ActiveGrammarSet set, Collection<GrammarDocument> removed) {
        try {
            UserInput input = this.platform.getUserInput();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("deactivating " + removed.size() + " grammars...");
            }
            int num = input.deactivateGrammars(removed);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("..." + num + " grammars deactivated");
            }
        }
        catch (NoresourceError e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (ConnectionDisconnectHangupEvent e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (BadFetchError e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

