/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Application;
import org.jvoicexml.LastResult;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;

public final class JVoiceXmlApplication
implements Application {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlApplication.class);
    private VoiceXmlDocument root;
    private VoiceXmlDocument current;
    private final Map<URI, VoiceXmlDocument> loadedDocuments;
    private URI application;
    private URI baseUri;
    private final transient ScopeObserver observer;
    private List<LastResult> lastresults;

    public JVoiceXmlApplication() {
        this.observer = null;
        this.loadedDocuments = new HashMap<URI, VoiceXmlDocument>();
    }

    public JVoiceXmlApplication(ScopeObserver scopeObserver) {
        this.observer = scopeObserver;
        this.loadedDocuments = new HashMap<URI, VoiceXmlDocument>();
    }

    @Override
    public void addDocument(URI uri, VoiceXmlDocument doc) throws BadFetchError {
        if (uri == null) {
            LOGGER.warn("no URI specified");
            return;
        }
        if (doc == null) {
            LOGGER.warn("cannot add a null document to application");
            return;
        }
        Vxml vxml = doc.getVxml();
        if (vxml == null) {
            LOGGER.warn("Is this a VoiceXML document? No vxml tag found");
            return;
        }
        try {
            URI currentApplication;
            this.baseUri = vxml.getXmlBaseUri();
            if (this.baseUri == null) {
                this.baseUri = uri;
            }
            if ((currentApplication = vxml.getApplicationUri()) == null) {
                this.loadedDocuments.clear();
                this.root = null;
            }
            if (this.application == null) {
                this.application = currentApplication;
            } else if (!this.application.equals(currentApplication)) {
                this.application = this.baseUri;
                this.loadedDocuments.clear();
                this.root = null;
            }
        }
        catch (URISyntaxException e) {
            throw new BadFetchError("Error adding the document to the application", e);
        }
        this.current = doc;
        URI resolved = this.resolve(uri);
        URI fragmentLess = this.removeFragment(resolved);
        this.loadedDocuments.put(fragmentLess, this.current);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loaded documents:");
            Set<URI> keys = this.loadedDocuments.keySet();
            for (URI loadedUri : keys) {
                LOGGER.debug("- " + loadedUri);
            }
        }
    }

    @Override
    public void setRootDocument(VoiceXmlDocument document) throws BadFetchError {
        if (this.root != null) {
            this.observer.exitScope(Scope.APPLICATION);
        }
        this.root = document;
        this.loadedDocuments.put(this.getApplication(), this.root);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loaded documents:");
            Set<URI> keys = this.loadedDocuments.keySet();
            for (URI loadedUri : keys) {
                LOGGER.debug("- " + loadedUri);
            }
        }
        this.observer.enterScope(Scope.APPLICATION);
    }

    @Override
    public URI getApplication() {
        return this.resolve(this.application);
    }

    @Override
    public URI getXmlBase() {
        return this.baseUri;
    }

    @Override
    public VoiceXmlDocument getCurrentDocument() {
        return this.current;
    }

    @Override
    public URI resolve(URI uri) {
        return this.resolve(this.baseUri, uri);
    }

    private URI removeFragment(URI uri) {
        String fragment = uri.getFragment();
        if (fragment == null) {
            return uri;
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("unable to remove the fragment from '" + uri + "'", (Throwable)e);
            return uri;
        }
    }

    @Override
    public URI resolve(URI base, URI uri) {
        URI currentBase;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolving URI '" + uri + "'...");
        }
        if (uri == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("cannot resolve null");
            }
            return null;
        }
        if (base == null) {
            if (this.baseUri == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Can not resolve '" + uri + "'. No base URI set.");
                }
                return uri;
            }
            currentBase = this.baseUri;
        } else {
            currentBase = base;
        }
        URI resolvedUri = currentBase.resolve(uri);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolved to '" + resolvedUri + "'");
        }
        return resolvedUri;
    }

    @Override
    public boolean isLoaded(URI uri) {
        if (uri == null) {
            return false;
        }
        String fragment = uri.getFragment();
        if (fragment == null) {
            return this.loadedDocuments.containsKey(uri);
        }
        URI fragmentLess = this.removeFragment(uri);
        return this.loadedDocuments.containsKey(fragmentLess);
    }

    public String toString() {
        if (this.application != null) {
            return this.application.toString();
        }
        return "Unknown application";
    }

    @Override
    public void setLastResult(List<LastResult> result) {
        this.lastresults = result;
    }

    @Override
    public List<LastResult> getLastResult() {
        return this.lastresults;
    }
}

