/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Application;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.DocumentDescriptor;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.DtmfInput;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.JVoiceXmlCore;
import org.jvoicexml.Session;
import org.jvoicexml.SessionListener;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.EventSubscriber;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.error.jvxml.ExceptionWrapper;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;
import org.jvoicexml.event.plain.implementation.SpokenInputEvent;
import org.jvoicexml.event.plain.implementation.SynthesizedOutputEvent;
import org.jvoicexml.interpreter.DetailedSessionListener;
import org.jvoicexml.interpreter.GrammarProcessor;
import org.jvoicexml.interpreter.JVoiceXmlApplication;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.Connection;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopedCollection;
import org.jvoicexml.profile.Profile;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.slf4j.MDC;

public class JVoiceXmlSession
extends Thread
implements Session,
EventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlSession.class);
    private final ConnectionInformation info;
    private VoiceXmlInterpreterContext context;
    private final ImplementationPlatform implementationPlatform;
    private final DocumentServer documentServer;
    private Application application;
    private final GrammarProcessor grammarProcessor;
    private final ScopeObserver scopeObserver;
    private final UUID uuid = UUID.randomUUID();
    private ErrorEvent processingError;
    private boolean closed;
    private final ScopedCollection<SessionListener> sessionListeners;
    private final Collection<DetailedSessionListener> detailedSessionListeners;
    private final Profile profile;
    private final Configuration configuration;
    private final Object sem;
    private URI applicationUri;

    public JVoiceXmlSession(ImplementationPlatform ip, JVoiceXmlCore jvxml, ConnectionInformation connectionInformation, Profile prof) {
        MDC.put((String)"sessionId", (String)this.uuid.toString());
        this.info = connectionInformation;
        this.profile = prof;
        this.implementationPlatform = ip;
        this.documentServer = jvxml.getDocumentServer();
        this.application = null;
        this.grammarProcessor = jvxml.getGrammarProcessor();
        this.scopeObserver = new ScopeObserver();
        this.configuration = jvxml.getConfiguration();
        this.sem = new Object();
        this.closed = false;
        this.sessionListeners = new ScopedCollection(this.scopeObserver);
        this.detailedSessionListeners = new ArrayList<DetailedSessionListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSessionListener(SessionListener listener) {
        ScopedCollection<SessionListener> scopedCollection = this.sessionListeners;
        synchronized (scopedCollection) {
            this.sessionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionListener(SessionListener listener) {
        ScopedCollection<SessionListener> scopedCollection = this.sessionListeners;
        synchronized (scopedCollection) {
            this.sessionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(DetailedSessionListener listener) {
        Collection<DetailedSessionListener> collection = this.detailedSessionListeners;
        synchronized (collection) {
            this.detailedSessionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(DetailedSessionListener listener) {
        Collection<DetailedSessionListener> collection = this.detailedSessionListeners;
        synchronized (collection) {
            this.detailedSessionListeners.remove(listener);
        }
    }

    @Override
    public String getSessionId() {
        return this.uuid.toString();
    }

    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public Application call(URI uri) throws ErrorEvent {
        if (this.closed) {
            throw new NoresourceError("Session is already closed");
        }
        MDC.put((String)"sessionId", (String)this.uuid.toString());
        this.application = new JVoiceXmlApplication(this.scopeObserver);
        this.applicationUri = uri;
        String sessionId = this.getSessionId();
        this.setName(sessionId);
        this.start();
        return this.application;
    }

    @Override
    public void hangup() {
        if (this.closed) {
            return;
        }
        LOGGER.info("initiating a hangup event");
        EventBus eventbus = this.context.getEventBus();
        ConnectionDisconnectHangupEvent event = new ConnectionDisconnectHangupEvent();
        eventbus.publish(event);
    }

    @Override
    public DtmfInput getDtmfInput() throws NoresourceError, ConnectionDisconnectHangupEvent {
        if (this.closed) {
            throw new NoresourceError("Session is already closed");
        }
        return this.implementationPlatform.getCharacterInput();
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSessionEnd() throws ErrorEvent {
        LOGGER.info("waiting for end of session...");
        if (this.processingError != null) {
            throw this.processingError;
        }
        Object object = this.sem;
        synchronized (object) {
            try {
                if (!this.closed) {
                    this.sem.wait();
                }
            }
            catch (InterruptedException e) {
                throw new NoresourceError("waiting for end of session interrupted", e);
            }
        }
        LOGGER.info("...session ended");
        if (this.processingError != null) {
            throw this.processingError;
        }
    }

    @Override
    public boolean hasEnded() {
        return this.closed;
    }

    private void createContext() {
        this.context = new VoiceXmlInterpreterContext(this, this.configuration);
        EventBus eventbus = this.context.getEventBus();
        eventbus.subscribe(SynthesizedOutputEvent.EVENT_TYPE, this);
        eventbus.subscribe(SpokenInputEvent.EVENT_TYPE, this);
        eventbus.subscribe("nomatch", this);
        this.profile.initialize(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String protocolName;
        URI callingDevice;
        URI calledDevice;
        this.createContext();
        try {
            DocumentDescriptor descriptor = new DocumentDescriptor(this.applicationUri);
            VoiceXmlDocument doc = this.context.loadDocument(descriptor);
            URI resolvedUri = descriptor.getUri();
            this.application.addDocument(resolvedUri, doc);
        }
        catch (BadFetchError e) {
            LOGGER.error("error processing application '" + this.application + "'", (Throwable)e);
            this.processingError = new ExceptionWrapper(e.getMessage(), e);
            this.cleanup();
            return;
        }
        if (this.info != null) {
            calledDevice = this.info.getCalledDevice();
            callingDevice = this.info.getCallingDevice();
            protocolName = this.info.getProtocolName();
            String protocolVersion = this.info.getProtocolVersion();
            LOGGER.info("start processing application '" + this.application + "' called from '" + callingDevice + "' to " + "'" + calledDevice + "' using protocol '" + protocolName + "' version '" + protocolVersion + "'...");
        } else {
            calledDevice = null;
            callingDevice = null;
            protocolName = null;
            Object protocolVersion = null;
            LOGGER.info("start processing application '" + this.application + "'...");
        }
        this.processingError = null;
        DataModel model = this.getDataModel();
        this.scopeObserver.enterScope(Scope.SESSION);
        Connection connection = new Connection(this.info);
        model.createVariable("session.connection", connection, Scope.SESSION);
        model.createVariable("session.sessionid", this.uuid, Scope.SESSION);
        this.context.setProperty("bargein", "true");
        this.notifySessionStarted();
        try {
            this.context.process(this.application);
        }
        catch (ErrorEvent e) {
            LOGGER.error("error processing application '" + this.application + "'", (Throwable)e);
            this.processingError = e;
        }
        catch (Exception e) {
            LOGGER.error("error processing application '" + this.application + "'", (Throwable)e);
            this.processingError = new ExceptionWrapper(e.getMessage(), e);
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        LOGGER.info("finished processing application '" + this.application + "'");
        if (this.closed) {
            return;
        }
        this.closed = true;
        LOGGER.info("closing session...");
        this.profile.terminate(this.context);
        this.implementationPlatform.close();
        String sessionId = this.getSessionId();
        this.documentServer.sessionClosed(sessionId);
        this.scopeObserver.exitScope(Scope.SESSION);
        this.context.close();
        LOGGER.info("...session closed");
        this.notifySessionEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionStarted() {
        Collection<Object> collection = this.sessionListeners;
        synchronized (collection) {
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.sessionStarted(this);
            }
        }
        collection = this.detailedSessionListeners;
        synchronized (collection) {
            for (DetailedSessionListener detailedSessionListener : this.detailedSessionListeners) {
                detailedSessionListener.sessionStarted(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionEnded() {
        Object object = this.sessionListeners;
        synchronized (object) {
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.sessionEnded(this);
            }
        }
        object = this.detailedSessionListeners;
        synchronized (object) {
            for (DetailedSessionListener detailedSessionListener : this.detailedSessionListeners) {
                detailedSessionListener.sessionEnded(this);
            }
        }
        object = this.sem;
        synchronized (object) {
            this.sem.notifyAll();
        }
    }

    public ImplementationPlatform getImplementationPlatform() {
        return this.implementationPlatform;
    }

    public DocumentServer getDocumentServer() {
        return this.documentServer;
    }

    public GrammarProcessor getGrammarProcessor() {
        return this.grammarProcessor;
    }

    public VoiceXmlInterpreterContext getVoiceXmlInterpreterContext() {
        return this.context;
    }

    public ScopeObserver getScopeObserver() {
        return this.scopeObserver;
    }

    public DataModel getDataModel() {
        return this.context.getDataModel();
    }

    @Override
    public ErrorEvent getLastError() {
        return this.processingError;
    }

    @Override
    public void onEvent(JVoiceXMLEvent event) {
        for (DetailedSessionListener listener : this.detailedSessionListeners) {
            listener.sessionEvent(this, event);
        }
    }
}

