/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Application;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.Session;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoauthorizationError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.error.UnsupportedObjectnameError;
import org.jvoicexml.event.plain.jvxml.ObjectTagResultEvent;
import org.jvoicexml.interpreter.ParamParser;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.ObjectFormItem;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.ObjectTag;

final class ObjectExecutorThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(ObjectExecutorThread.class);
    private final VoiceXmlInterpreterContext context;
    private final ObjectFormItem object;
    private final EventBus eventbus;
    private final Collection<Object> parameter;
    private final Application application;
    private final URL applicationBase;
    private static final ClassLoader LOADER = ObjectExecutorThread.class.getClassLoader();
    private static final Map<Collection<URI>, ClassLoader> LOADERS = new HashMap<Collection<URI>, ClassLoader>();

    ObjectExecutorThread(VoiceXmlInterpreterContext ctx, ObjectFormItem item) throws SemanticError, BadFetchError {
        this.setDaemon(true);
        this.setName("ObjectExecutor");
        this.context = ctx;
        this.object = item;
        this.eventbus = this.context.getEventBus();
        this.application = this.context.getApplication();
        if (this.application == null) {
            this.applicationBase = null;
        } else {
            URI baseUri = this.application.getXmlBase();
            if (baseUri == null) {
                this.applicationBase = null;
            } else {
                try {
                    this.applicationBase = baseUri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new SemanticError(e.getMessage(), e);
                }
            }
        }
        ObjectTag tag = (ObjectTag)this.object.getNode();
        DataModel model = this.context.getDataModel();
        DocumentServer server = this.context.getDocumentServer();
        Session session = this.context.getSession();
        ParamParser parser = new ParamParser((VoiceXmlNode)tag, model, server, session);
        this.parameter = parser.getParameterValues();
    }

    @Override
    public void run() {
        try {
            Object result = this.execute();
            ObjectTagResultEvent event = new ObjectTagResultEvent(result);
            this.eventbus.publish(event);
        }
        catch (JVoiceXMLEvent e) {
            this.eventbus.publish(e);
        }
    }

    private Object execute() throws SemanticError, NoresourceError, NoauthorizationError, BadFetchError, UnsupportedObjectnameError {
        String method;
        ObjectTag tag = (ObjectTag)this.object.getNode();
        Object invocationTarget = this.getInvocationTarget(tag);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("try to execute: '" + invocationTarget.getClass().getName() + "'");
        }
        try {
            method = this.getMethodName(tag);
        }
        catch (URISyntaxException e) {
            throw new SemanticError("Must specify attribute a valid URI for: classid");
        }
        return this.targetExecute(invocationTarget, method);
    }

    private Object getInvocationTarget(ObjectTag tag) throws SemanticError, NoresourceError, UnsupportedObjectnameError {
        Object invocationTarget;
        ArrayList<URI> uris;
        URI classid;
        try {
            classid = tag.getClassidUri();
        }
        catch (URISyntaxException e) {
            throw new SemanticError("Must specify attribute a valid URI for: classid");
        }
        if (classid == null) {
            throw new SemanticError("Must specify attribute: classid");
        }
        String scheme = classid.getScheme();
        if (scheme == null) {
            throw new SemanticError("Must specify a scheme for the classid '" + classid + "'");
        }
        if (!scheme.equals("method")) {
            throw new UnsupportedObjectnameError("scheme '" + scheme + "' is not supported by this implementation.");
        }
        String className = classid.getAuthority();
        try {
            uris = tag.getArchiveUris();
            if (uris == null) {
                uris = new ArrayList<URI>();
            }
        }
        catch (URISyntaxException e) {
            throw new SemanticError("Must specify a comma separated list of valid URIs for: archive");
        }
        try {
            URI data = tag.getDataUri();
            if (data != null) {
                uris.add(data);
            }
        }
        catch (URISyntaxException e) {
            throw new SemanticError("Must specify a valid URI for: data");
        }
        ClassLoader loader = this.getClassLoader(uris);
        try {
            LOGGER.info("loading '" + className + "'");
            Class<?> cls = loader.loadClass(className);
            invocationTarget = cls.newInstance();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created instance of '" + cls.getName() + "'");
            }
        }
        catch (ClassNotFoundException e) {
            throw new NoresourceError("class not found '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new NoresourceError("unable to access '" + className + "'", e);
        }
        catch (InstantiationException e) {
            throw new NoresourceError("unable to instantiate '" + className + "'", e);
        }
        return invocationTarget;
    }

    private synchronized ClassLoader getClassLoader(Collection<URI> uris) throws SemanticError {
        if (uris == null || uris.isEmpty()) {
            if (this.applicationBase == null) {
                return LOADER;
            }
            LOGGER.info("adding '" + this.applicationBase + "' to CLASSPATH");
            URL[] urls = new URL[]{this.applicationBase};
            return new URLClassLoader(urls, LOADER);
        }
        ClassLoader loader = LOADERS.get(uris);
        if (loader != null) {
            return loader;
        }
        LOGGER.info("adding '" + uris + "' to CLASSPATH");
        URL[] urls = new URL[uris.size()];
        int i = 0;
        for (URI uri : uris) {
            try {
                URI resolved = this.application.resolve(uri);
                urls[i] = resolved.toURL();
                ++i;
            }
            catch (MalformedURLException e) {
                throw new SemanticError("Must specify a valid URI for: data (" + uri + ")");
            }
        }
        loader = new URLClassLoader(urls, LOADER);
        LOADERS.put(uris, loader);
        return loader;
    }

    private String getMethodName(ObjectTag tag) throws URISyntaxException {
        URI classid = tag.getClassidUri();
        String fragment = classid.getFragment();
        if (fragment == null) {
            return "invoke";
        }
        return fragment;
    }

    private Object targetExecute(Object invocationTarget, String methodName) throws NoauthorizationError {
        if (invocationTarget == null) {
            return null;
        }
        Class[] sig = new Class[this.parameter.size()];
        Object[] args = new Object[this.parameter.size()];
        int i = 0;
        for (Object value : this.parameter) {
            sig[i] = value.getClass();
            args[i] = value;
            ++i;
        }
        Class<?> clazz = invocationTarget.getClass();
        if (LOGGER.isDebugEnabled()) {
            StringBuilder str = new StringBuilder();
            str.append(clazz.getName());
            str.append('.');
            str.append(methodName);
            str.append('(');
            Iterator<Object> iterator = this.parameter.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value instanceof String) {
                    str.append('\'');
                }
                str.append(value);
                if (value instanceof String) {
                    str.append('\'');
                }
                if (!iterator.hasNext()) continue;
                str.append(", ");
            }
            str.append(")");
            LOGGER.debug("calling " + str);
        }
        try {
            Method method = clazz.getMethod(methodName, sig);
            Object result = method.invoke(invocationTarget, args);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result of call is '" + result + "'");
            }
            if (result == null) {
                return new Object();
            }
            return result;
        }
        catch (SecurityException e) {
            throw new NoauthorizationError("Object tag invocation error " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new NoauthorizationError("Object tag invocation error " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new NoauthorizationError("Object tag invocation error " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new NoauthorizationError("Object tag invocation error " + e.getMessage(), e);
        }
    }
}

