/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jvoicexml.DocumentDescriptor;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.Session;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Param;
import org.jvoicexml.xml.vxml.ParamValueType;

class ParamParser {
    private final VoiceXmlNode node;
    private final DataModel model;
    private final DocumentServer server;
    private final String sessionId;

    ParamParser(VoiceXmlNode vxml, DataModel dataModel, DocumentServer documentServer, Session currentSession) {
        this.node = vxml;
        this.model = dataModel;
        this.server = documentServer;
        this.sessionId = currentSession.getSessionId();
    }

    public Map<String, Object> getParameters() throws SemanticError, BadFetchError {
        Collection paramtags = this.node.getChildNodes(Param.class);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Param param : paramtags) {
            String name = param.getName();
            Object value = param.getValue();
            if (value == null) {
                String expr = param.getExpr();
                if (expr == null) {
                    throw new BadFetchError("Exactly one of \"value\" or \"expr\" must be specified in a param tag!");
                }
                String unescapedExpr = StringEscapeUtils.unescapeXml((String)expr);
                value = this.model.evaluateExpression(unescapedExpr, Object.class);
            } else {
                ParamValueType valueType = param.getValuetype();
                if (valueType == ParamValueType.REF) {
                    URI uri;
                    try {
                        uri = new URI(value.toString());
                    }
                    catch (URISyntaxException e) {
                        throw new BadFetchError("'" + value + "' is not a valid URI");
                    }
                    String type = param.getType();
                    DocumentDescriptor descriptor = new DocumentDescriptor(uri);
                    value = this.server.getObject(this.sessionId, descriptor, type);
                }
            }
            parameters.put(name, value);
        }
        return parameters;
    }

    public Collection<Object> getParameterValues() throws SemanticError, BadFetchError {
        Collection paramtags = this.node.getChildNodes(Param.class);
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Param param : paramtags) {
            Object value = param.getValue();
            if (value == null) {
                String expr = param.getExpr();
                if (expr == null) {
                    throw new BadFetchError("Exactly one of \"value\" or \"expr\" must be specified in a param tag!");
                }
                String unescapedExpr = StringEscapeUtils.unescapeXml((String)expr);
                value = this.model.evaluateExpression(unescapedExpr, Object.class);
            } else {
                ParamValueType valueType = param.getValuetype();
                if (valueType == ParamValueType.REF) {
                    URI uri;
                    try {
                        uri = new URI(value.toString());
                    }
                    catch (URISyntaxException e) {
                        throw new BadFetchError("'" + value + "' is not a valid URI");
                    }
                    String type = param.getType();
                    DocumentDescriptor descriptor = new DocumentDescriptor(uri);
                    value = this.server.getObject(this.sessionId, descriptor, type);
                }
            }
            parameters.add(value);
        }
        return parameters;
    }
}

