/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.PromptCountable;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.ssml.Audio;
import org.jvoicexml.xml.vxml.Prompt;
import org.jvoicexml.xml.vxml.Value;

final class PromptChooser {
    private static final Logger LOGGER = LogManager.getLogger(PromptChooser.class);
    private final PromptCountable countable;
    private final VoiceXmlInterpreterContext context;

    PromptChooser(PromptCountable cnt, VoiceXmlInterpreterContext ctx) {
        this.countable = cnt;
        this.context = ctx;
    }

    public Collection<VoiceXmlNode> collect() throws SemanticError {
        int count = this.countable.getPromptCount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("find all prompts of '" + this.countable.getName() + "' with count " + count);
        }
        Collection<VoiceXmlNode> allPrompts = this.findAllPrompts();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + allPrompts.size() + " prompt(s) in '" + this.countable.getName() + "'");
        }
        Collection<VoiceXmlNode> condPrompts = this.filterCond(allPrompts);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + condPrompts.size() + " prompt(s) after cond evaluation in '" + this.countable.getName() + "'");
        }
        int highestCount = this.findHighestCount(condPrompts, count);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("highest count of " + this.countable.getName() + "' is " + highestCount + " <= " + count);
        }
        Collection<VoiceXmlNode> correctCountPrompts = this.filterCount(condPrompts, highestCount);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + correctCountPrompts.size() + " prompt(s) with count " + highestCount + " in '" + this.countable.getName() + "'");
        }
        return correctCountPrompts;
    }

    private Collection<VoiceXmlNode> findAllPrompts() {
        ArrayList<VoiceXmlNode> prompts = new ArrayList<VoiceXmlNode>();
        VoiceXmlNode node = this.countable.getNode();
        Collection children = node.getChildren();
        for (VoiceXmlNode child : children) {
            if (child instanceof Prompt) {
                prompts.add(child);
                continue;
            }
            if (child instanceof Text) {
                prompts.add(child);
                continue;
            }
            if (child instanceof Audio) {
                prompts.add(child);
                continue;
            }
            if (!(child instanceof Value)) continue;
            prompts.add(child);
        }
        return prompts;
    }

    private Collection<VoiceXmlNode> filterCond(Collection<VoiceXmlNode> prompts) throws SemanticError {
        ArrayList<VoiceXmlNode> filteredPrompts = new ArrayList<VoiceXmlNode>();
        DataModel model = this.context.getDataModel();
        for (VoiceXmlNode node : prompts) {
            if (node instanceof Prompt) {
                Prompt prompt = (Prompt)node;
                String cond = prompt.getCond();
                String unescapedCond = StringEscapeUtils.unescapeXml((String)cond);
                boolean result = model.evaluateExpression(unescapedCond, Boolean.class);
                if (!result) continue;
                filteredPrompts.add((VoiceXmlNode)prompt);
                continue;
            }
            filteredPrompts.add(node);
        }
        return filteredPrompts;
    }

    private int findHighestCount(Collection<VoiceXmlNode> prompts, int count) {
        int highestCount = 0;
        for (VoiceXmlNode node : prompts) {
            int currentCount;
            if (node instanceof Prompt) {
                Prompt prompt = (Prompt)node;
                currentCount = prompt.getCountAsInt();
            } else {
                currentCount = 1;
            }
            if (currentCount > count || currentCount <= highestCount) continue;
            highestCount = currentCount;
        }
        return highestCount;
    }

    private Collection<VoiceXmlNode> filterCount(Collection<VoiceXmlNode> prompts, int count) {
        ArrayList<VoiceXmlNode> filteredPrompts = new ArrayList<VoiceXmlNode>();
        for (VoiceXmlNode node : prompts) {
            int currentCount;
            if (node instanceof Prompt) {
                Prompt prompt = (Prompt)node;
                currentCount = prompt.getCountAsInt();
            } else {
                currentCount = 1;
            }
            if (currentCount != count) continue;
            filteredPrompts.add(node);
        }
        return filteredPrompts;
    }
}

