/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.plain.jvxml.RecordingEvent;

final class RecordingReceiverThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(RecordingReceiverThread.class);
    private final EventBus eventbus;
    private final long maxTime;
    private final ByteArrayOutputStream out;

    RecordingReceiverThread(EventBus bus, long recordingTime) {
        this.eventbus = bus;
        this.maxTime = recordingTime;
        this.setDaemon(true);
        this.setName("RecordingReceiverThread");
        this.out = new ByteArrayOutputStream();
    }

    @Override
    public void run() {
        LOGGER.info("waiting until record max timeout " + this.maxTime + " expired");
        try {
            Thread.sleep(this.maxTime);
        }
        catch (InterruptedException e) {
            NoresourceError event = new NoresourceError(e.getMessage(), e);
            this.eventbus.publish(event);
            return;
        }
        byte[] buffer = this.out.toByteArray();
        RecordingEvent event = new RecordingEvent(buffer);
        this.eventbus.publish(event);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

