/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jvoicexml.Application;
import org.jvoicexml.DocumentDescriptor;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.plain.jvxml.ReturnEvent;
import org.jvoicexml.event.plain.jvxml.SubdialogResultEvent;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.scope.Scope;

final class SubdialogExecutorThread
extends Thread {
    private final URI uri;
    private final VoiceXmlInterpreterContext context;
    private final Application application;
    private final EventBus eventbus;
    private final Map<String, Object> parameters;

    SubdialogExecutorThread(URI subdialogUri, VoiceXmlInterpreterContext subdialogContext, Application appl, Map<String, Object> params, EventBus bus) {
        this.uri = subdialogUri;
        this.context = subdialogContext;
        this.application = appl;
        this.eventbus = bus;
        this.parameters = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DataModel model = this.context.getDataModel();
        model.createScope(Scope.DIALOG);
        try {
            DocumentDescriptor descriptor = new DocumentDescriptor(this.uri);
            this.context.processSubdialog(this.application, descriptor, this.parameters);
        }
        catch (ReturnEvent e) {
            Object result;
            try {
                result = this.getReturnObject(e);
            }
            catch (SemanticError sematicerror) {
                this.eventbus.publish(sematicerror);
                return;
            }
            SubdialogResultEvent event = new SubdialogResultEvent(result);
            this.eventbus.publish(event);
            return;
        }
        catch (JVoiceXMLEvent e) {
            this.eventbus.publish(e);
            return;
        }
        finally {
            model.deleteScope(Scope.DIALOG);
        }
        SubdialogResultEvent event = new SubdialogResultEvent(Boolean.TRUE);
        this.eventbus.publish(event);
    }

    private Object getReturnObject(ReturnEvent event) throws SemanticError {
        StringBuilder str = new StringBuilder();
        str.append("var out = new Object();");
        Map<String, Object> variables = event.getVariables();
        for (String name : variables.keySet()) {
            str.append("out.");
            str.append(name);
            str.append(" = ");
            Object value = variables.get(name);
            if (value instanceof String) {
                str.append("\"");
                str.append(value);
                str.append("\"");
            } else {
                str.append(value);
            }
            str.append(";");
        }
        DataModel model = this.context.getDataModel();
        String expr = str.toString();
        String unescapedExpr = StringEscapeUtils.unescapeXml((String)expr);
        model.evaluateExpression(unescapedExpr, Object.class);
        return model.readVariable("out", Object.class);
    }
}

