/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.DialogFactory;
import org.jvoicexml.interpreter.EventHandler;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.InterpreterState;
import org.jvoicexml.interpreter.JVoiceXmlSession;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.profile.Profile;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;

public final class VoiceXmlInterpreter {
    private static final Logger LOGGER = LogManager.getLogger(VoiceXmlInterpreter.class);
    private final VoiceXmlInterpreterContext context;
    private FormInterpretationAlgorithm fia;
    private VoiceXmlDocument document;
    private Locale documentLocale;
    private Collection<Dialog> dialogs;
    private Dialog nextDialog;
    private InterpreterState state;
    private boolean finalProcessingState;

    public VoiceXmlInterpreter(VoiceXmlInterpreterContext ctx) {
        this.context = ctx;
    }

    public FormInterpretationAlgorithm getFormInterpretationAlgorithm() {
        return this.fia;
    }

    public InterpreterState getState() {
        return this.state;
    }

    public void setState(InterpreterState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        LOGGER.info("entered state " + (Object)((Object)this.state));
    }

    void setDocument(VoiceXmlDocument doc, String startDialog, Configuration configuration) throws ConfigurationException {
        if (doc == null) {
            this.document = null;
            return;
        }
        this.document = doc;
        Vxml vxml = this.document.getVxml();
        if (vxml == null) {
            LOGGER.warn("no vxml tag found in '" + doc + "'");
            return;
        }
        DialogFactory factory = configuration.loadObject(DialogFactory.class);
        this.dialogs = factory.getDialogs(vxml);
        if (startDialog == null) {
            Iterator<Dialog> iterator = this.dialogs.iterator();
            if (iterator.hasNext()) {
                this.nextDialog = iterator.next();
            }
        } else {
            this.nextDialog = this.getDialog(startDialog);
        }
        if (this.nextDialog == null) {
            if (startDialog == null) {
                LOGGER.info("the document does not contain any dialogs");
            } else {
                LOGGER.warn("start dialog '" + startDialog + "' not found in document!");
            }
        } else {
            LOGGER.info("interpreter starts with dialog '" + this.nextDialog.getId() + "'");
        }
    }

    public Dialog getNextDialog() {
        return this.nextDialog;
    }

    public Dialog getDialog(String id) {
        if (id == null) {
            LOGGER.warn("unable to get form with a null id");
            return null;
        }
        if (this.dialogs == null) {
            LOGGER.warn("dialogs not initialized. can not determine dialog with id '" + id + "'");
            return null;
        }
        for (Dialog dialog : this.dialogs) {
            String currentId = dialog.getId();
            if (!id.equalsIgnoreCase(currentId)) continue;
            return dialog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Dialog dialog, Map<String, Object> parameters) throws JVoiceXMLEvent {
        this.nextDialog = null;
        this.fia = new FormInterpretationAlgorithm(this.context, this, dialog);
        EventHandler eventHandler = this.context.getEventHandler();
        eventHandler.collect(this.context, this, dialog);
        JVoiceXmlSession session = (JVoiceXmlSession)this.context.getSession();
        Profile profile = session.getProfile();
        try {
            try {
                this.fia.initialize(profile, parameters);
            }
            catch (JVoiceXMLEvent event) {
                EventBus eventbus = this.context.getEventBus();
                eventbus.publish(event);
            }
            this.fia.mainLoop();
        }
        finally {
            this.fia = null;
        }
    }

    public void enterFinalProcessingState() {
        LOGGER.info("entered final processing state");
        this.finalProcessingState = true;
    }

    public boolean isInFinalProcessingState() {
        return this.finalProcessingState;
    }

    public Locale getLanguage() {
        if (this.documentLocale != null) {
            return this.documentLocale;
        }
        if (this.document == null) {
            return null;
        }
        Vxml vxml = this.document.getVxml();
        Locale locale = vxml.getXmlLangObject();
        this.documentLocale = locale != null ? locale : Locale.getDefault();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("document default language is " + this.documentLocale);
        }
        return this.documentLocale;
    }
}

