/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Application;
import org.jvoicexml.CallControlProperties;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.DocumentDescriptor;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.DtmfRecognizerProperties;
import org.jvoicexml.FetchAttributes;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.Session;
import org.jvoicexml.SpeechRecognizerProperties;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.error.jvxml.ExceptionWrapper;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;
import org.jvoicexml.event.plain.jvxml.GotoNextDocumentEvent;
import org.jvoicexml.event.plain.jvxml.GotoNextFormEvent;
import org.jvoicexml.event.plain.jvxml.InternalExitEvent;
import org.jvoicexml.event.plain.jvxml.SubmitEvent;
import org.jvoicexml.interpreter.ActiveGrammarSet;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.EventHandler;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.GrammarDeactivator;
import org.jvoicexml.interpreter.GrammarProcessor;
import org.jvoicexml.interpreter.JVoiceXmlSession;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.datamodel.DataModelScopeSubscriber;
import org.jvoicexml.interpreter.event.JVoiceXmlEventHandler;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopedMap;
import org.jvoicexml.profile.Profile;
import org.jvoicexml.profile.TagStrategy;
import org.jvoicexml.profile.TagStrategyFactory;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VoiceXmlInterpreterContext {
    private static final Logger LOGGER = LogManager.getLogger(VoiceXmlInterpreterContext.class);
    private final JVoiceXmlSession session;
    private final ScopeObserver scopeObserver;
    private final ActiveGrammarSet grammars;
    private final ScopedMap<String, String> properties;
    private Application application;
    private DataModel model;
    private final EventBus eventbus;
    private final EventHandler eventHandler;
    private final Configuration configuration;

    public VoiceXmlInterpreterContext(JVoiceXmlSession currentSession, Configuration config) {
        this.session = currentSession;
        this.configuration = config;
        this.scopeObserver = this.session.getScopeObserver();
        this.grammars = new ActiveGrammarSet(this.scopeObserver);
        ImplementationPlatform platform = this.session.getImplementationPlatform();
        GrammarDeactivator deactivator = new GrammarDeactivator(platform);
        this.grammars.addActiveGrammarSetObserver(deactivator);
        this.eventbus = new EventBus();
        this.properties = new ScopedMap(this.scopeObserver);
        DataModel dataModel = this.getDataModel();
        this.eventHandler = new JVoiceXmlEventHandler(dataModel, this.scopeObserver);
        this.eventbus.subscribe("", this.eventHandler);
    }

    public VoiceXmlInterpreterContext(JVoiceXmlSession currentSession, Configuration config, ScopeObserver observer) {
        this.session = currentSession;
        this.scopeObserver = observer;
        this.configuration = config;
        this.grammars = new ActiveGrammarSet(this.scopeObserver);
        ImplementationPlatform platform = this.session.getImplementationPlatform();
        GrammarDeactivator deactivator = new GrammarDeactivator(platform);
        this.grammars.addActiveGrammarSetObserver(deactivator);
        this.properties = new ScopedMap(this.scopeObserver);
        this.eventbus = new EventBus();
        this.eventHandler = new JVoiceXmlEventHandler(this.model, this.scopeObserver);
        this.eventbus.subscribe("", this.eventHandler);
    }

    public Session getSession() {
        return this.session;
    }

    public Profile getProfile() {
        return this.session.getProfile();
    }

    public ScopeObserver getScopeObserver() {
        return this.scopeObserver;
    }

    public ImplementationPlatform getImplementationPlatform() {
        return this.session.getImplementationPlatform();
    }

    public GrammarProcessor getGrammarProcessor() {
        return this.session.getGrammarProcessor();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DataModel getDataModel() {
        if (this.model == null) {
            try {
                Collection<DataModel> models = this.configuration.loadObjects(DataModel.class, "datamodel");
                if (models.isEmpty()) {
                    LOGGER.warn("no data model configured");
                    return null;
                }
                Iterator<DataModel> iterator = models.iterator();
                this.model = iterator.next();
                LOGGER.info("loaded data model '" + this.model + "'");
            }
            catch (ConfigurationException e) {
                LOGGER.error("error loading data model: " + e.getMessage(), (Throwable)e);
                return null;
            }
            DataModelScopeSubscriber subscriber = new DataModelScopeSubscriber(this.model);
            this.scopeObserver.addScopeSubscriber(subscriber);
        }
        return this.model;
    }

    public EventBus getEventBus() {
        return this.eventbus;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void enterScope(Scope scope) {
        if (this.scopeObserver == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no scope observer set. Cannot propagate entering of scope '" + (Object)((Object)scope) + "'");
            }
            return;
        }
        this.scopeObserver.enterScope(scope);
    }

    public void exitScope(Scope scope) {
        if (this.scopeObserver == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no scope observer set. Cannot propagate exiting of scope '" + (Object)((Object)scope) + "'");
            }
            return;
        }
        this.scopeObserver.exitScope(scope);
    }

    public void close() {
    }

    public ActiveGrammarSet getActiveGrammarSet() {
        return this.grammars;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getProperty(String name, String defValue) {
        String value = this.properties.get(name);
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public SpeechRecognizerProperties getSpeechRecognizerProperties(FormInterpretationAlgorithm fia) throws ConfigurationException {
        SpeechRecognizerProperties speech = this.configuration.loadObject(SpeechRecognizerProperties.class);
        Map<String, String> props = this.getProperties(fia);
        speech.setProperties(props);
        return speech;
    }

    public DtmfRecognizerProperties getDtmfRecognizerProperties(FormInterpretationAlgorithm fia) throws ConfigurationException {
        DtmfRecognizerProperties dtmf = this.configuration.loadObject(DtmfRecognizerProperties.class);
        Map<String, String> props = this.getProperties(fia);
        dtmf.setProperties(props);
        return dtmf;
    }

    public CallControlProperties getCallControlProperties(FormInterpretationAlgorithm fia) throws ConfigurationException {
        CallControlProperties call = this.configuration.loadObject(CallControlProperties.class);
        if (call == null) {
            return null;
        }
        Map<String, String> props = this.getProperties(fia);
        call.setProperties(props);
        return call;
    }

    private Map<String, String> getProperties(FormInterpretationAlgorithm fia) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        if (fia != null) {
            Map<String, String> localProperties = fia.getLocalProperties();
            props.putAll(localProperties);
        }
        return props;
    }

    public void setApplication(Application value) {
        this.application = value;
    }

    public Application getApplication() {
        return this.application;
    }

    public void process(Application appl) throws ErrorEvent {
        this.setApplication(appl);
        VoiceXmlDocument document = this.application.getCurrentDocument();
        this.enterScope(Scope.APPLICATION);
        this.model.createArray("lastresult$", 0);
        this.model.createVariable("lastresult$.confidence", null, Scope.APPLICATION);
        this.model.createVariable("lastresult$.utterance", null, Scope.APPLICATION);
        this.model.createVariable("lastresult$.inputmode", null, Scope.APPLICATION);
        this.model.createVariable("lastresult$.interpretation", null, Scope.APPLICATION);
        DocumentDescriptor descriptor = null;
        while (document != null) {
            URI rootUri = this.application.getApplication();
            if (rootUri != null && !this.application.isLoaded(rootUri)) {
                this.loadRootDocument(rootUri);
            }
            try {
                String dialog;
                URI uri;
                this.enterScope(Scope.DOCUMENT);
                if (descriptor != null) {
                    uri = descriptor.getUri();
                    dialog = uri.getFragment();
                } else {
                    dialog = null;
                }
                descriptor = this.interpret(document, dialog, null);
                if (descriptor == null) {
                    document = null;
                    continue;
                }
                document = this.application.getCurrentDocument();
                uri = descriptor.getUri();
                if (document == null || !descriptor.isForceLoad() && this.application.isLoaded(uri)) continue;
                document = this.loadDocument(descriptor);
            }
            catch (InternalExitEvent e) {
                LOGGER.info("exit request. terminating processing");
                document = null;
            }
            catch (ErrorEvent e) {
                throw e;
            }
            catch (ConnectionDisconnectHangupEvent e) {
                LOGGER.info("user hung up. terminating processing");
                document = null;
            }
            catch (JVoiceXMLEvent e) {
                throw new BadFetchError("unhandled event '" + e.getEventType() + "'", e);
            }
            finally {
                this.exitScope(Scope.DOCUMENT);
            }
        }
        LOGGER.info("no more documents to process for '" + this.application + "'");
        this.exitScope(Scope.APPLICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSubdialog(Application appl, DocumentDescriptor desc, Map<String, Object> parameters) throws JVoiceXMLEvent {
        this.application = appl;
        VoiceXmlDocument document = this.application.getCurrentDocument();
        DocumentDescriptor descriptor = desc;
        while (document != null) {
            try {
                String dialog;
                URI uri;
                this.enterScope(Scope.DOCUMENT);
                if (descriptor != null) {
                    uri = descriptor.getUri();
                    dialog = uri.getFragment();
                } else {
                    dialog = null;
                }
                descriptor = this.interpret(document, dialog, parameters);
                if (descriptor == null) {
                    document = null;
                    continue;
                }
                document = this.application.getCurrentDocument();
                uri = descriptor.getUri();
                if (document == null || this.application.isLoaded(uri)) continue;
                document = this.loadDocument(descriptor);
            }
            catch (InternalExitEvent e) {
                LOGGER.info("exit request. terminating processing of subdialog");
                document = null;
            }
            finally {
                this.exitScope(Scope.DOCUMENT);
            }
        }
    }

    private void loadRootDocument(URI uri) throws BadFetchError, SemanticError {
        URI applicationUri;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loading root document...");
        }
        DocumentDescriptor descriptor = new DocumentDescriptor(uri);
        VoiceXmlDocument document = this.acquireVoiceXmlDocument(descriptor);
        Vxml vxml = document.getVxml();
        try {
            applicationUri = vxml.getApplicationUri();
        }
        catch (URISyntaxException e) {
            throw new SemanticError("Application root document '" + uri + "' does not contain a valid URI");
        }
        if (applicationUri != null) {
            throw new SemanticError("Application root document '" + uri + "' must not have an application attribute");
        }
        this.application.setRootDocument(document);
        try {
            this.initDocument(document, null);
        }
        catch (BadFetchError e) {
            throw e;
        }
        catch (SemanticError e) {
            throw e;
        }
        catch (JVoiceXMLEvent e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...done loading root document");
        }
    }

    public VoiceXmlDocument loadDocument(DocumentDescriptor descriptor) throws BadFetchError {
        VoiceXmlDocument doc = this.acquireVoiceXmlDocument(descriptor);
        URI uri = descriptor.getUri();
        if (this.application != null) {
            URI resolvedUri = this.application.resolve(uri);
            this.application.addDocument(resolvedUri, doc);
        }
        return doc;
    }

    public DocumentServer getDocumentServer() {
        return this.session.getDocumentServer();
    }

    public VoiceXmlDocument acquireVoiceXmlDocument(DocumentDescriptor descriptor) throws BadFetchError {
        URI uri = descriptor.getUri();
        URI nextUri = this.application == null ? uri : this.application.resolve(uri);
        descriptor.setURI(nextUri);
        DocumentServer server = this.session.getDocumentServer();
        String sessionId = this.session.getSessionId();
        return server.getDocument(sessionId, descriptor);
    }

    public GrammarDocument acquireExternalGrammar(URI uri, FetchAttributes attributes) throws BadFetchError {
        DocumentServer server = this.session.getDocumentServer();
        URI grammarUri = this.application == null ? uri : this.application.resolve(uri);
        String sessionId = this.session.getSessionId();
        return server.getGrammarDocument(sessionId, grammarUri, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentDescriptor interpret(VoiceXmlDocument document, String startDialog, Map<String, Object> parameters) throws JVoiceXMLEvent {
        Dialog dialog;
        VoiceXmlInterpreter interpreter = new VoiceXmlInterpreter(this);
        try {
            interpreter.setDocument(document, startDialog, this.configuration);
        }
        catch (ConfigurationException e) {
            throw new ExceptionWrapper(e.getMessage(), e);
        }
        if (startDialog != null && (dialog = interpreter.getNextDialog()) == null) {
            throw new BadFetchError("Target of goto '" + startDialog + "' not found in current document");
        }
        this.initDocument(document, interpreter);
        dialog = interpreter.getNextDialog();
        while (dialog != null) {
            try {
                this.enterScope(Scope.DIALOG);
                interpreter.process(dialog, parameters);
                dialog = interpreter.getNextDialog();
            }
            catch (GotoNextFormEvent e) {
                String id = e.getForm();
                dialog = interpreter.getDialog(id);
                if (dialog != null) continue;
                throw new BadFetchError("Target of goto '" + id + "'not found in current document");
            }
            catch (GotoNextDocumentEvent e) {
                URI uri = e.getUri();
                DocumentDescriptor documentDescriptor = new DocumentDescriptor(uri);
                return documentDescriptor;
            }
            catch (SubmitEvent e) {
                DocumentDescriptor documentDescriptor = e.getDocumentDescriptor();
                return documentDescriptor;
            }
            finally {
                this.exitScope(Scope.DIALOG);
            }
        }
        return null;
    }

    private void initDocument(VoiceXmlDocument document, VoiceXmlInterpreter interpreter) throws JVoiceXMLEvent {
        LOGGER.info("initializing document...");
        this.eventHandler.collect(this, interpreter, document);
        Vxml vxml = document.getVxml();
        NodeList list = vxml.getChildNodes();
        JVoiceXmlSession jvxmlsession = (JVoiceXmlSession)this.getSession();
        Profile profile = jvxmlsession.getProfile();
        TagStrategyFactory factory = profile.getInitializationTagStrategyFactory();
        for (int i = 0; i < list.getLength(); ++i) {
            VoiceXmlNode node;
            TagStrategy strategy;
            Node currentNode = list.item(i);
            if (!(currentNode instanceof VoiceXmlNode) || (strategy = factory.getTagStrategy((Node)(node = (VoiceXmlNode)currentNode))) == null) continue;
            strategy.getAttributes(this, null, node);
            strategy.evalAttributes(this);
            if (LOGGER.isDebugEnabled()) {
                strategy.dumpNode(this.model, node);
            }
            strategy.validateAttributes(this.model);
            strategy.execute(this, interpreter, null, null, node);
        }
        LOGGER.info("...done initializing document");
    }
}

