/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.datamodel;

import java.net.URI;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.interpreter.datamodel.ConnectionLocal;
import org.jvoicexml.interpreter.datamodel.ConnectionProtocol;
import org.jvoicexml.interpreter.datamodel.ConnectionRemote;

public final class Connection {
    private ConnectionRemote remote;
    private ConnectionLocal local;
    private final ConnectionProtocol protocol;

    public Connection(ConnectionInformation info) {
        String protocolName = info.getProtocolName();
        String protocolVersion = info.getProtocolVersion();
        this.protocol = new ConnectionProtocol(protocolName, protocolVersion);
        URI remoteUri = info.getCallingDevice();
        this.remote = new ConnectionRemote(remoteUri);
        URI localUri = info.getCalledDevice();
        this.local = new ConnectionLocal(localUri);
    }

    public void setRemoteCallerDevice(URI uri) {
        this.remote = new ConnectionRemote(uri);
    }

    public ConnectionRemote getRemote() {
        return this.remote;
    }

    public void setLocalCallerDevice(URI uri) {
        this.local = new ConnectionLocal(uri);
    }

    public ConnectionLocal getLocal() {
        return this.local;
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }
}

