/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.dialog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.GenericVoiceXmlEvent;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.dialog.ChoiceConverter;
import org.jvoicexml.interpreter.dialog.ConvertedChoiceOption;
import org.jvoicexml.interpreter.dialog.DialogIdFactory;
import org.jvoicexml.interpreter.formitem.FieldFormItem;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.TextContainer;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.Item;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.OneOf;
import org.jvoicexml.xml.srgs.Rule;
import org.jvoicexml.xml.vxml.AbstractCatchElement;
import org.jvoicexml.xml.vxml.AcceptType;
import org.jvoicexml.xml.vxml.Choice;
import org.jvoicexml.xml.vxml.Elseif;
import org.jvoicexml.xml.vxml.Enumerate;
import org.jvoicexml.xml.vxml.Field;
import org.jvoicexml.xml.vxml.Filled;
import org.jvoicexml.xml.vxml.Goto;
import org.jvoicexml.xml.vxml.If;
import org.jvoicexml.xml.vxml.Menu;
import org.jvoicexml.xml.vxml.Prompt;
import org.jvoicexml.xml.vxml.Reprompt;
import org.jvoicexml.xml.vxml.Throw;
import org.jvoicexml.xml.vxml.Value;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExecutableMenuForm
implements Dialog {
    private static final Logger LOGGER = LogManager.getLogger(ExecutableMenuForm.class);
    private static final int MAX_DTMF_VALUE = 9;
    private Menu menu;
    private String id;
    private Field field;
    private ChoiceConverter converter;

    @Override
    public void setNode(XmlNode node) throws IllegalArgumentException {
        if (!(node instanceof Menu)) {
            throw new IllegalArgumentException("'" + node + "' is not a menu!");
        }
        this.menu = (Menu)node;
        this.id = DialogIdFactory.getId((VoiceXmlNode)this.menu);
    }

    public void setChoiceConverter(ChoiceConverter choiceConverter) {
        this.converter = choiceConverter;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<XmlNode> getChildNodes() {
        if (this.field == null) {
            LOGGER.warn("anonymous field for '" + this.id + "' has not been yet created");
            return null;
        }
        return this.field.getChildren();
    }

    @Override
    public Collection<FormItem> getFormItems(VoiceXmlInterpreterContext context) throws BadFetchError {
        if (this.field == null) {
            this.field = this.createAnonymousField(context);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("created anonymous field");
                LOGGER.debug((Object)this.field);
            }
        }
        ArrayList<FormItem> items = new ArrayList<FormItem>();
        FieldFormItem item = new FieldFormItem(context, (VoiceXmlNode)this.field);
        items.add(item);
        return items;
    }

    private Field createAnonymousField(VoiceXmlInterpreterContext context) throws BadFetchError {
        Collection<ConvertedChoiceOption> converted;
        Document document = this.menu.getOwnerDocument();
        Element newNode = document.createElement("field");
        this.field = new Field((Node)newNode);
        this.field.setName(this.getId());
        Collection choices = this.menu.getChildNodes(Choice.class);
        try {
            boolean dtmf = this.menu.isDtmf();
            converted = this.convertChoices(choices, dtmf);
        }
        catch (URISyntaxException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        this.createGrammars(converted, ModeType.VOICE);
        this.createGrammars(converted, ModeType.DTMF);
        this.createFilled(converted);
        this.copyPrompts(converted);
        this.expandEnumerates(converted);
        this.copyRemainigNodes();
        return this.field;
    }

    private Collection<ConvertedChoiceOption> convertChoices(Collection<Choice> choices, boolean dtmf) throws URISyntaxException, BadFetchError {
        ArrayList<ConvertedChoiceOption> converted = new ArrayList<ConvertedChoiceOption>();
        int count = 1;
        for (Choice choice : choices) {
            String dtmfValue;
            ConvertedChoiceOption conv = new ConvertedChoiceOption(this.field);
            AcceptType accept = choice.isAcceptSpecified() ? choice.getAcceptObject() : this.menu.getAcceptObject();
            conv.setAccept(accept);
            URI uri = choice.getNextUri();
            conv.setNext(uri);
            String event = choice.getEvent();
            String message = choice.getMessage();
            JVoiceXMLEvent e = this.createEvent(event, message);
            conv.setEvent(e);
            String choiceText = choice.getFirstLevelTextContent();
            String text = choiceText.trim();
            conv.setText(text);
            if (dtmf) {
                dtmfValue = choice.getDtmf();
                if (dtmfValue == null) {
                    choice.setDtmf(Integer.toString(count));
                    if (++count > 9) {
                        throw new BadFetchError("More than 9 choices in menu '" + this.id + "'");
                    }
                } else if (!(dtmfValue.equals("0") || dtmfValue.equals("#") || dtmfValue.endsWith("*"))) {
                    throw new BadFetchError("menu '" + this.id + "' set dtmf to true but choice has an invalid value ('" + dtmfValue + "')");
                }
            }
            dtmfValue = choice.getDtmf();
            conv.setDtmf(dtmfValue);
            ConvertedChoiceOption convDtmf = conv.clone();
            convDtmf.setMode(ModeType.DTMF);
            conv.setMode(ModeType.VOICE);
            this.converter.convertChoice(choice, ModeType.VOICE, conv);
            this.converter.convertChoice(choice, ModeType.DTMF, convDtmf);
            converted.add(conv);
            converted.add(convDtmf);
        }
        return converted;
    }

    private void createGrammars(Collection<ConvertedChoiceOption> converted, ModeType mode) {
        boolean hasGrammar = false;
        ArrayList<String> items = new ArrayList<String>();
        for (ConvertedChoiceOption conv : converted) {
            if (conv.getMode() != mode) continue;
            Collection<String> inputs = conv.getAcceptedInputs();
            if (inputs != null) {
                items.addAll(inputs);
            }
            hasGrammar |= conv.getGrammar() != null;
        }
        if (items.isEmpty() || hasGrammar) {
            return;
        }
        Grammar grammar = (Grammar)this.field.appendChild(Grammar.class);
        grammar.setRoot(this.field.getName() + mode);
        grammar.setVersion("1.0");
        grammar.setType(GrammarType.SRGS_XML);
        VoiceXmlDocument owner = (VoiceXmlDocument)grammar.getOwnerXmlDocument(VoiceXmlDocument.class);
        Vxml vxml = owner.getVxml();
        String lang = vxml.getXmlLang();
        if (lang == null) {
            LOGGER.warn("No xml:lang attribute specified in vxml. Can not set xml:lang in created voice grammar");
        } else {
            grammar.setXmlLang(lang);
        }
        grammar.setMode(mode);
        Rule rule = (Rule)grammar.appendChild(Rule.class);
        rule.setId(grammar.getRoot());
        rule.setScope("public");
        OneOf oneOf = (OneOf)rule.appendChild(OneOf.class);
        for (String current : items) {
            Item item = (Item)oneOf.appendChild(Item.class);
            item.addText(current);
        }
    }

    private void createFilled(Collection<ConvertedChoiceOption> converted) {
        If iftag;
        Filled filled = (Filled)this.field.appendChild(Filled.class);
        Object node = iftag = (If)filled.appendChild(If.class);
        String name = this.field.getName();
        for (ConvertedChoiceOption conv : converted) {
            Collection<String> inputs = conv.getAcceptedInputs();
            if (inputs == null) continue;
            for (String input : inputs) {
                node = iftag.hasChildNodes() ? iftag.appendChild(Elseif.class) : iftag;
                StringBuilder str = new StringBuilder();
                str.append(name);
                str.append("=='");
                str.append(input);
                str.append("'");
                String condition = str.toString();
                node.setAttribute("cond", condition);
                if (conv.getEvent() != null) {
                    JVoiceXMLEvent event = conv.getEvent();
                    String type = event.getEventType();
                    String message = event.getMessage();
                    Throw throwTag = (Throw)iftag.appendChild(Throw.class);
                    throwTag.setEvent(type);
                    throwTag.setMessage(message);
                    continue;
                }
                Goto gotoTag = (Goto)iftag.appendChild(Goto.class);
                URI uri = conv.getNext();
                gotoTag.setNext(uri);
            }
        }
        filled.appendChild(Reprompt.class);
    }

    private void copyPrompts(Collection<ConvertedChoiceOption> converted) {
        Collection prompts = this.menu.getChildNodes(Prompt.class);
        for (Prompt prompt : prompts) {
            this.copyPrompt(prompt, converted);
        }
    }

    private void copyPrompt(Prompt prompt, Collection<ConvertedChoiceOption> converted) {
        Prompt createdPrompt = (Prompt)this.field.appendChild(Prompt.class);
        Collection nodes = prompt.getChildren();
        for (XmlNode node : nodes) {
            if (node instanceof Enumerate) {
                Enumerate enumerate = (Enumerate)node;
                this.expandEnumerate(createdPrompt, enumerate, converted);
                continue;
            }
            if (node instanceof TextContainer) {
                TextContainer container = (TextContainer)node;
                String text = container.getTextContent();
                createdPrompt.addText(text);
                continue;
            }
            if (node instanceof Text) {
                Text text = (Text)node;
                String value = text.getTextContent();
                createdPrompt.addText(value);
                continue;
            }
            Node clonedNode = node.cloneNode(true);
            createdPrompt.appendChild(clonedNode);
        }
    }

    private JVoiceXMLEvent createEvent(String event, String message) {
        if (event == null) {
            return null;
        }
        return new GenericVoiceXmlEvent(event, message);
    }

    private void expandEnumerates(Collection<ConvertedChoiceOption> converted) {
        Collection enumerates = this.menu.getChildNodes(Enumerate.class);
        for (Enumerate enumerate : enumerates) {
            Prompt prompt = (Prompt)this.field.appendChild(Prompt.class);
            this.expandEnumerate(prompt, enumerate, converted);
        }
    }

    private void expandEnumerate(Prompt prompt, Enumerate enumerate, Collection<ConvertedChoiceOption> converted) {
        for (ConvertedChoiceOption conv : converted) {
            if (conv.getMode() != ModeType.VOICE) continue;
            Collection nodes = enumerate.getChildren();
            if (nodes.isEmpty()) {
                String text = conv.getText();
                prompt.addText(text);
                continue;
            }
            for (XmlNode node : nodes) {
                if (node instanceof Value) {
                    Value value = (Value)node;
                    String expr = value.getExpr();
                    if ("_prompt".equalsIgnoreCase(expr)) {
                        String text = conv.getText();
                        prompt.addText(text);
                        continue;
                    }
                    if ("_dtmf".equalsIgnoreCase(expr)) {
                        String dtmf = conv.getDtmf();
                        prompt.addText(dtmf);
                        continue;
                    }
                    Node clonedNode = node.cloneNode(true);
                    prompt.appendChild(clonedNode);
                    continue;
                }
                if (node instanceof TextContainer) {
                    TextContainer container = (TextContainer)node;
                    String text = container.getTextContent();
                    prompt.addText(text);
                    continue;
                }
                if (node instanceof Text) {
                    Text text = (Text)node;
                    String value = text.getTextContent();
                    prompt.addText(value);
                    continue;
                }
                Node clonedNode = node.cloneNode(true);
                prompt.appendChild(clonedNode);
            }
        }
    }

    @Override
    public Collection<Filled> getFilledElements() {
        return null;
    }

    private void copyRemainigNodes() {
        Collection nodes = this.menu.getChildren();
        for (XmlNode node : nodes) {
            if (node instanceof Prompt || node instanceof Choice || node instanceof Enumerate) continue;
            Node clonedNode = node.cloneNode(true);
            this.field.appendChild(clonedNode);
        }
    }

    @Override
    public Collection<AbstractCatchElement> getCatchElements() {
        if (this.menu == null) {
            return null;
        }
        ArrayList<AbstractCatchElement> catches = new ArrayList<AbstractCatchElement>();
        NodeList children = this.menu.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof AbstractCatchElement)) continue;
            AbstractCatchElement catchElement = (AbstractCatchElement)child;
            catches.add(catchElement);
        }
        return catches;
    }

    @Override
    public Dialog clone() {
        try {
            return (Dialog)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

