/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.dialog;

import java.util.ArrayList;
import java.util.Collection;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.dialog.DialogIdFactory;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.interpreter.formitem.FormItemFactory;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.vxml.AbstractCatchElement;
import org.jvoicexml.xml.vxml.Filled;
import org.jvoicexml.xml.vxml.Form;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExecutablePlainForm
implements Dialog {
    private Form form;
    private String id;
    private Collection<FormItem> items;

    @Override
    public void setNode(XmlNode node) throws IllegalArgumentException {
        if (!(node instanceof Form)) {
            throw new IllegalArgumentException("'" + node + "' is not a from!");
        }
        this.form = (Form)node;
        this.id = DialogIdFactory.getId((VoiceXmlNode)this.form);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<XmlNode> getChildNodes() {
        return this.form.getChildren();
    }

    @Override
    public Collection<FormItem> getFormItems(VoiceXmlInterpreterContext context) throws BadFetchError {
        if (this.items == null) {
            this.items = new ArrayList<FormItem>();
            NodeList children = this.form.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                VoiceXmlNode node = (VoiceXmlNode)children.item(i);
                AbstractFormItem item = FormItemFactory.getFormItem(context, node);
                if (item == null) continue;
                this.items.add(item);
            }
        }
        return this.items;
    }

    @Override
    public Collection<Filled> getFilledElements() {
        return this.form.getChildNodes(Filled.class);
    }

    @Override
    public Collection<AbstractCatchElement> getCatchElements() {
        if (this.form == null) {
            return null;
        }
        ArrayList<AbstractCatchElement> catches = new ArrayList<AbstractCatchElement>();
        NodeList children = this.form.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof AbstractCatchElement)) continue;
            AbstractCatchElement catchElement = (AbstractCatchElement)child;
            catches.add(catchElement);
        }
        return catches;
    }

    @Override
    public Dialog clone() {
        try {
            return (Dialog)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

