/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.DialogFactory;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.vxml.Vxml;

public final class JVoiceXmlDialogFactory
implements DialogFactory {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlDialogFactory.class);
    private final Map<String, Dialog> dialogs = new HashMap<String, Dialog>();

    public void setDialogs(Map<String, Dialog> mappings) {
        Set<String> tags = mappings.keySet();
        for (String tag : tags) {
            Dialog dialog = mappings.get(tag);
            this.addDialogMapping(tag, dialog);
        }
    }

    public void addDialogMapping(String tag, Dialog dialog) {
        this.dialogs.put(tag, dialog);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added dialog template '" + dialog.getClass() + "' to handle tag '" + tag + "'");
        }
    }

    @Override
    public Collection<Dialog> getDialogs(Vxml vxml) {
        ArrayList<Dialog> col = new ArrayList<Dialog>();
        Collection children = vxml.getChildren();
        for (XmlNode node : children) {
            String tagname = node.getTagName();
            Dialog template = this.dialogs.get(tagname);
            if (template == null) continue;
            Dialog dialog = template.clone();
            dialog.setNode(node);
            col.add(dialog);
        }
        return col;
    }
}

