/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.JVoiceXmlSession;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.profile.Profile;
import org.jvoicexml.profile.TagStrategyExecutor;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.AbstractCatchElement;

abstract class AbstractEventStrategy
implements EventStrategy {
    private static final int HASH_CODE_BASE = 3;
    private static final int HASH_CODE_MULTIPLIER = 5;
    private final VoiceXmlInterpreterContext context;
    private final VoiceXmlInterpreter interpreter;
    private FormInterpretationAlgorithm fia;
    private FormItem item;
    private final VoiceXmlNode node;
    private final String event;
    private final int count;

    AbstractEventStrategy() {
        this.context = null;
        this.interpreter = null;
        this.fia = null;
        this.item = null;
        this.node = null;
        this.event = null;
        this.count = 0;
    }

    protected AbstractEventStrategy(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter ip, FormInterpretationAlgorithm algorithm, FormItem formItem, VoiceXmlNode n, String type) {
        String countAttribute;
        this.context = ctx;
        this.interpreter = ip;
        this.fia = algorithm;
        this.item = formItem;
        this.node = n;
        this.event = type;
        this.count = this.node == null ? 1 : ((countAttribute = this.node.getAttribute("count")) == null ? 1 : Integer.valueOf(countAttribute));
    }

    protected final VoiceXmlInterpreterContext getVoiceXmlInterpreterContext() {
        return this.context;
    }

    protected final VoiceXmlInterpreter getVoiceXmlInterpreter() {
        return this.interpreter;
    }

    protected final FormInterpretationAlgorithm getFormInterpretationAlgorithm() {
        if (this.fia == null) {
            if (this.interpreter == null) {
                return null;
            }
            this.fia = this.interpreter.getFormInterpretationAlgorithm();
        }
        return this.fia;
    }

    protected TagStrategyExecutor getTagStrategyExecutor() {
        if (this.fia == null) {
            JVoiceXmlSession session = (JVoiceXmlSession)this.context.getSession();
            Profile profile = session.getProfile();
            return new TagStrategyExecutor(profile);
        }
        return this.fia.getTagStrategyExecutor();
    }

    protected FormItem getCurrentFormItem() {
        if (this.item == null) {
            FormInterpretationAlgorithm algorithm = this.getFormInterpretationAlgorithm();
            if (algorithm == null) {
                return null;
            }
            this.item = algorithm.getFormItem();
        }
        return this.item;
    }

    public FormItem getFormItem() {
        return this.item;
    }

    protected final VoiceXmlNode getVoiceXmlNode() {
        return this.node;
    }

    @Override
    public final String getEventType() {
        return this.event;
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    @Override
    public final boolean isActive() throws SemanticError {
        if (!(this.node instanceof AbstractCatchElement)) {
            return true;
        }
        AbstractCatchElement catchElement = (AbstractCatchElement)this.node;
        String cond = catchElement.getCond();
        if (cond == null) {
            return true;
        }
        DataModel model = this.context.getDataModel();
        String unescapedCond = StringEscapeUtils.unescapeXml((String)cond);
        return model.evaluateExpression(unescapedCond, Boolean.class);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractEventStrategy)) {
            return false;
        }
        AbstractEventStrategy strategy = (AbstractEventStrategy)obj;
        if (this.context != strategy.context && this.context != null && !this.context.equals(strategy.context)) {
            return false;
        }
        if (this.interpreter != strategy.interpreter && this.interpreter != null && !this.interpreter.equals(strategy.interpreter)) {
            return false;
        }
        if (this.fia != strategy.fia && this.fia != null && !this.fia.equals(strategy.fia)) {
            return false;
        }
        if (this.item != strategy.item && this.item != null && !this.item.equals(strategy.item)) {
            return false;
        }
        if (this.node != strategy.node && this.node != null && !this.node.equals(strategy.node)) {
            return false;
        }
        if (this.event != strategy.event && this.event != null && !this.event.equals(strategy.event)) {
            return false;
        }
        return this.count == strategy.count;
    }

    public int hashCode() {
        int hash = 3;
        hash *= 5;
        if (this.context != null) {
            hash += this.context.hashCode();
        }
        hash *= 5;
        if (this.interpreter != null) {
            hash += this.interpreter.hashCode();
        }
        hash *= 5;
        if (this.fia != null) {
            hash += this.fia.hashCode();
        }
        hash *= 5;
        if (this.item != null) {
            hash += this.item.hashCode();
        }
        hash *= 5;
        if (this.node != null) {
            hash += this.node.hashCode();
        }
        return (hash *= 5) + this.count;
    }
}

