/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.plain.jvxml.InputEvent;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.InputItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.event.AbstractEventStrategy;
import org.jvoicexml.profile.TagStrategyExecutor;
import org.jvoicexml.xml.TokenList;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Filled;
import org.jvoicexml.xml.vxml.FilledMode;
import org.jvoicexml.xml.vxml.Form;
import org.w3c.dom.Node;

abstract class AbstractInputItemEventStrategy<T extends InputItem>
extends AbstractEventStrategy {
    private static final Logger LOGGER = LogManager.getLogger(AbstractInputItemEventStrategy.class);

    AbstractInputItemEventStrategy() {
    }

    AbstractInputItemEventStrategy(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm algorithm, FormItem formItem, String type) {
        super(ctx, interpreter, algorithm, formItem, null, type);
    }

    @Override
    public void process(JVoiceXMLEvent event) throws JVoiceXMLEvent {
        InputItem item;
        boolean continueProcessing;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processing event " + event + "...");
        }
        if (!(continueProcessing = this.handleEvent(item = (InputItem)this.getCurrentFormItem(), event))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("processing aborted");
            }
            return;
        }
        InputEvent inputEvent = (InputEvent)((Object)event);
        Object result = inputEvent.getInputResult();
        this.setResult(item, inputEvent, result);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("executing filled elements...");
        }
        Collection<Filled> filledElements = item.getFilledElements();
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        Dialog dialog = fia.getDialog();
        Collection<Filled> dialogFilledElements = dialog.getFilledElements();
        if (dialogFilledElements != null) {
            filledElements.addAll(dialogFilledElements);
        }
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        DataModel model = context.getDataModel();
        VoiceXmlInterpreter interpreter = this.getVoiceXmlInterpreter();
        TagStrategyExecutor executor = this.getTagStrategyExecutor();
        if (fia.isJustFilled(item)) {
            for (Filled filled : filledElements) {
                if (!this.shouldExecute(filled, model)) continue;
                executor.executeChildNodes(context, interpreter, fia, (FormItem)item, (VoiceXmlNode)filled);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...done executing filled element");
        }
    }

    private boolean shouldExecute(Filled filled, DataModel model) throws SemanticError {
        Node parent = filled.getParentNode();
        if (!(parent instanceof Form)) {
            return true;
        }
        FilledMode mode = filled.getModeObject();
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        TokenList tokens = filled.getNameListObject();
        Collection<FormItem> formItems = fia.getFormItems();
        if (tokens.isEmpty()) {
            for (FormItem formItem : formItems) {
                if (!(formItem instanceof InputItem)) continue;
                String name = formItem.getName();
                tokens.add(name);
            }
        }
        if (mode == FilledMode.ALL) {
            return this.areAllFilled(tokens, model);
        }
        return this.isAnyFilled(tokens, model);
    }

    private boolean areAllFilled(TokenList tokens, DataModel model) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checking if all input items of '" + tokens + "' are filled");
        }
        for (String token : tokens) {
            Object object = model.readVariable(token, Object.class);
            if (object != null && object != model.getUndefinedValue()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("not all filled: '" + token + "' is not defined");
            }
            return false;
        }
        LOGGER.info("all input items of '" + tokens + "' are filled");
        return true;
    }

    private boolean isAnyFilled(TokenList tokens, DataModel model) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checking if any input items of '" + tokens + "' are filled");
        }
        for (String token : tokens) {
            Object object = model.readVariable(token, Object.class);
            if (object == null || object == model.getUndefinedValue()) continue;
            LOGGER.info("any filled: '" + token + "' is defined");
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("none of input items of '" + tokens + "' are filled");
        }
        return false;
    }

    protected void setResult(T item, InputEvent event, Object result) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setting form item variable to '" + result + "'");
        }
        item.setFormItemVariable(result);
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        if (fia != null) {
            fia.setJustFilled((InputItem)item);
        }
    }

    protected abstract boolean handleEvent(T var1, JVoiceXMLEvent var2) throws JVoiceXMLEvent;
}

