/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.plain.implementation.NomatchEvent;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.event.AbstractEventStrategy;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.profile.TagStrategyExecutor;
import org.jvoicexml.xml.VoiceXmlNode;

final class CatchEventStrategy
extends AbstractEventStrategy {
    private static final Logger LOGGER = LogManager.getLogger(CatchEventStrategy.class);

    CatchEventStrategy() {
    }

    CatchEventStrategy(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter ip, FormInterpretationAlgorithm interpreter, FormItem formItem, VoiceXmlNode node, String type) {
        super(ctx, ip, interpreter, formItem, node, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(JVoiceXMLEvent event) throws JVoiceXMLEvent {
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        if (fia == null) {
            LOGGER.warn("Unable to process event '" + event.getEventType() + "' No reference to a form FIA!");
            return;
        }
        if (event instanceof NomatchEvent) {
            NomatchEvent nomatch = (NomatchEvent)event;
            RecognitionResult result = nomatch.getRecognitionResult();
            this.setApplicationLastResult(result);
        }
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        context.enterScope(Scope.ANONYMOUS);
        DataModel model = context.getDataModel();
        String name = event.getEventType();
        model.createVariable("_event", name);
        VoiceXmlInterpreter interpreter = this.getVoiceXmlInterpreter();
        TagStrategyExecutor executor = this.getTagStrategyExecutor();
        try {
            FormItem item = this.getCurrentFormItem();
            VoiceXmlNode node = this.getVoiceXmlNode();
            executor.executeChildNodes(context, interpreter, fia, item, node);
        }
        finally {
            context.exitScope(Scope.ANONYMOUS);
        }
    }

    private void setApplicationLastResult(RecognitionResult result) throws SemanticError {
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        DataModel model = context.getDataModel();
        model.resizeArray("lastresult$", 1, Scope.APPLICATION);
        Object value = model.readArray("lastresult$", 0, Scope.APPLICATION, Object.class);
        model.createVariableFor(value, "confidence", Float.valueOf(result.getConfidence()));
        model.createVariableFor(value, "utterance", result.getUtterance());
        model.createVariableFor(value, "inputmode", result.getMode().name());
        model.createVariableFor(value, "interpretation", result.getSemanticInterpretation(model));
        model.updateArray("lastresult$", 0, value, Scope.APPLICATION);
        model.createVariable("lastresult$.interpretation", result.getSemanticInterpretation(model), Scope.APPLICATION);
        model.createVariable("lastresult$.confidence", Float.valueOf(result.getConfidence()), Scope.APPLICATION);
        model.createVariable("lastresult$.utterance", result.getUtterance(), Scope.APPLICATION);
        model.createVariable("lastresult$.inputmode", result.getMode().name(), Scope.APPLICATION);
    }
}

