/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.EventCountable;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.event.EventFilter;

final class EventCountTypeFilter
implements EventFilter {
    private static final Logger LOGGER = LogManager.getLogger(EventCountTypeFilter.class);

    EventCountTypeFilter() {
    }

    @Override
    public void filter(Collection<EventStrategy> strategies, JVoiceXMLEvent event, CatchContainer item) {
        int size = strategies.size();
        ArrayList<EventStrategy> matchingStrategies = new ArrayList<EventStrategy>();
        for (EventStrategy strategy : strategies) {
            EventCountable countable;
            int count;
            String type = strategy.getEventType();
            if (!(item instanceof EventCountable) || (count = (countable = (EventCountable)((Object)item)).getEventCount(type)) < strategy.getCount()) continue;
            matchingStrategies.add(strategy);
        }
        strategies.retainAll(matchingStrategies);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("reducing event strategies by count from " + size + " to " + matchingStrategies.size());
        }
    }
}

