/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.event.EventStrategyPrototype;
import org.jvoicexml.interpreter.event.FormLevelRecognitionEventStrategy;
import org.jvoicexml.interpreter.event.InputItemRecognitionEventStrategy;
import org.jvoicexml.interpreter.event.ObjectTagEventStrategy;
import org.jvoicexml.interpreter.event.RecordingEventStrategy;
import org.jvoicexml.interpreter.event.SubdialogEventStrategy;
import org.jvoicexml.interpreter.event.TransferEventStrategy;

final class EventStrategyDecoratorFactory {
    private static final Logger LOGGER = LogManager.getLogger(EventStrategyDecoratorFactory.class);
    private static final Map<String, EventStrategyPrototype> STRATEGIES = new HashMap<String, EventStrategyPrototype>();

    EventStrategyDecoratorFactory() {
    }

    public EventStrategy getDecorator(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, CatchContainer item) {
        if (item == null) {
            LOGGER.warn("can not obtain a decorator for a null input item");
            return null;
        }
        String tagName = item.getNodeTagName();
        EventStrategyPrototype prototype = STRATEGIES.get(tagName);
        if (prototype == null) {
            LOGGER.warn("no decorator for tag '" + tagName + "'");
            return null;
        }
        return prototype.newInstance(context, interpreter, fia, item);
    }

    static {
        STRATEGIES.put("field", new InputItemRecognitionEventStrategy());
        STRATEGIES.put("initial", new FormLevelRecognitionEventStrategy());
        STRATEGIES.put("object", new ObjectTagEventStrategy());
        STRATEGIES.put("record", new RecordingEventStrategy());
        STRATEGIES.put("subdialog", new SubdialogEventStrategy());
        STRATEGIES.put("transfer", new TransferEventStrategy());
    }
}

