/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.event.EventFilter;

final class EventTypeFilter
implements EventFilter {
    private static final Logger LOGGER = LogManager.getLogger(EventTypeFilter.class);

    EventTypeFilter() {
    }

    @Override
    public void filter(Collection<EventStrategy> strategies, JVoiceXMLEvent event, CatchContainer item) {
        String type = event.getEventType();
        ArrayList<EventStrategy> matchingStrategies = new ArrayList<EventStrategy>();
        for (EventStrategy strategy : strategies) {
            String currentType = strategy.getEventType();
            if (currentType == null) {
                matchingStrategies.add(strategy);
                continue;
            }
            if (!type.startsWith(currentType)) continue;
            matchingStrategies.add(strategy);
        }
        strategies.retainAll(matchingStrategies);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + matchingStrategies.size() + " matching event strategies for type '" + type + "'");
        }
    }
}

