/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.plain.implementation.RecognitionEvent;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.InputItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.event.AbstractEventStrategy;
import org.jvoicexml.interpreter.event.EventStrategyPrototype;
import org.jvoicexml.interpreter.formitem.FieldFormItem;
import org.jvoicexml.interpreter.formitem.InitialFormItem;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.profile.TagStrategyExecutor;
import org.jvoicexml.xml.TokenList;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Filled;
import org.jvoicexml.xml.vxml.FilledMode;

final class FormLevelRecognitionEventStrategy
extends AbstractEventStrategy
implements EventStrategyPrototype {
    private static final Logger LOGGER = LogManager.getLogger(FormLevelRecognitionEventStrategy.class);
    private final Dialog dialog;
    private Collection<InputItem> inputItems;
    private Collection<InitialFormItem> initalItems;

    FormLevelRecognitionEventStrategy() {
        this.dialog = null;
    }

    FormLevelRecognitionEventStrategy(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm algorithm, Dialog dlg) {
        super(ctx, interpreter, algorithm, null, null, RecognitionEvent.EVENT_TYPE);
        this.dialog = dlg;
    }

    private Collection<InputItem> getInputItems() throws BadFetchError {
        if (this.inputItems == null) {
            VoiceXmlInterpreterContext ctx = this.getVoiceXmlInterpreterContext();
            Collection<FormItem> formItems = this.dialog.getFormItems(ctx);
            this.inputItems = new ArrayList<InputItem>();
            for (FormItem formItem : formItems) {
                if (!(formItem instanceof InputItem)) continue;
                InputItem item = (InputItem)formItem;
                this.inputItems.add(item);
            }
        }
        return this.inputItems;
    }

    private Collection<InitialFormItem> getInitialItems() throws BadFetchError {
        if (this.initalItems == null) {
            VoiceXmlInterpreterContext ctx = this.getVoiceXmlInterpreterContext();
            Collection<FormItem> formItems = this.dialog.getFormItems(ctx);
            this.initalItems = new ArrayList<InitialFormItem>();
            for (FormItem formItem : formItems) {
                if (!(formItem instanceof InitialFormItem)) continue;
                InitialFormItem item = (InitialFormItem)formItem;
                this.initalItems.add(item);
            }
        }
        return this.initalItems;
    }

    private void setApplicationLastResult(RecognitionResult result) throws SemanticError {
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        DataModel model = context.getDataModel();
        model.resizeArray("lastresult$", 1, Scope.APPLICATION);
        Object value = model.readArray("lastresult$", 0, Scope.APPLICATION, Object.class);
        model.createVariableFor(value, "confidence", Float.valueOf(result.getConfidence()));
        model.createVariableFor(value, "utterance", result.getUtterance());
        model.createVariableFor(value, "inputmode", result.getMode().name());
        model.createVariableFor(value, "interpretation", result.getSemanticInterpretation(model));
        model.updateArray("lastresult$", 0, value, Scope.APPLICATION);
        model.createVariable("lastresult$.interpretation", result.getSemanticInterpretation(model), Scope.APPLICATION);
        model.createVariable("lastresult$.confidence", Float.valueOf(result.getConfidence()), Scope.APPLICATION);
        model.createVariable("lastresult$.utterance", result.getUtterance(), Scope.APPLICATION);
        model.createVariable("lastresult$.inputmode", result.getMode().name(), Scope.APPLICATION);
    }

    @Override
    public void process(JVoiceXMLEvent event) throws JVoiceXMLEvent {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processing event " + event + "...");
        }
        RecognitionEvent recognitionEvent = (RecognitionEvent)event;
        RecognitionResult result = recognitionEvent.getRecognitionResult();
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        DataModel model = context.getDataModel();
        this.setApplicationLastResult(result);
        Collection<InputItem> filtered = this.filterEvent(model, result);
        if (filtered == null || filtered.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no matching form items: processing aborted");
            }
            return;
        }
        this.setFilledInputItems(result, filtered);
        this.setInitialFormItems();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("executing filled elements...");
        }
        Collection<Filled> filledElements = this.dialog.getFilledElements();
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        VoiceXmlInterpreter interpreter = this.getVoiceXmlInterpreter();
        TagStrategyExecutor executor = this.getTagStrategyExecutor();
        for (Filled filled : filledElements) {
            if (!this.shouldExecute(filled, model)) continue;
            executor.executeChildNodes(context, interpreter, fia, null, (VoiceXmlNode)filled);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...done executing filled element");
        }
    }

    private boolean shouldExecute(Filled filled, DataModel model) throws SemanticError {
        FilledMode mode = filled.getModeObject();
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        TokenList tokens = filled.getNameListObject();
        Collection<FormItem> formItems = fia.getFormItems();
        if (tokens.isEmpty()) {
            for (FormItem formItem : formItems) {
                if (!(formItem instanceof InputItem)) continue;
                String name = formItem.getName();
                tokens.add(name);
            }
        }
        if (mode == FilledMode.ALL) {
            return this.areAllFilled(tokens, model);
        }
        return this.isAnyFilled(tokens, model);
    }

    private boolean areAllFilled(TokenList tokens, DataModel model) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checking if all input items of '" + tokens + "' are filled");
        }
        for (String token : tokens) {
            Object object = model.readVariable(token, Object.class);
            if (object != null && object != model.getUndefinedValue()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("not all filled: '" + token + "' is not defined");
            }
            return false;
        }
        LOGGER.info("all input items of '" + tokens + "' are filled");
        return true;
    }

    private boolean isAnyFilled(TokenList tokens, DataModel model) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checking if any input items of '" + tokens + "' are filled");
        }
        for (String token : tokens) {
            Object object = model.readVariable(token, Object.class);
            if (object == null || object == model.getUndefinedValue()) continue;
            LOGGER.info("any filled: '" + token + "' is defined");
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("none of input items of '" + tokens + "' are filled");
        }
        return false;
    }

    private void setFilledInputItems(RecognitionResult result, Collection<InputItem> filtered) throws SemanticError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setting the filled form items...");
        }
        FormInterpretationAlgorithm fia = this.getFormInterpretationAlgorithm();
        for (InputItem item : filtered) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setting form item variable to '" + result + "'");
            }
            item.setFormItemVariable(result);
            if (fia == null) continue;
            fia.setJustFilled(item);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...done setting the filled form items");
        }
    }

    private Collection<InputItem> filterEvent(DataModel model, RecognitionResult result) throws BadFetchError, SemanticError {
        if (!result.isAccepted()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result not accepted");
            }
            return null;
        }
        Object interpretation = result.getSemanticInterpretation(model);
        if (interpretation == null) {
            LOGGER.warn("result has no sematic interpretation: can not be processed!");
            return null;
        }
        String str = model.toString(interpretation);
        LOGGER.info("semantic interpretation: '" + str + "'");
        ArrayList<InputItem> filtered = new ArrayList<InputItem>();
        Collection<InputItem> items = this.getInputItems();
        for (InputItem item : items) {
            String slot;
            if (item instanceof FieldFormItem) {
                FieldFormItem field = (FieldFormItem)item;
                slot = field.getSlot();
            } else {
                slot = item.getName();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("checking input item '" + item.getName() + "' with slot '" + slot + "'");
            }
            try {
                Object value = model.readVariable("application.lastresult$.interpretation." + slot, Object.class);
                if (value == null) continue;
                filtered.add(item);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("added input item '" + item.getName() + "'");
            }
            catch (SemanticError e) {
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return filtered;
    }

    private void setInitialFormItems() throws BadFetchError, SemanticError {
        Collection<InitialFormItem> items = this.getInitialItems();
        for (InitialFormItem item : items) {
            item.setFormItemVariable(Boolean.TRUE);
        }
    }

    @Override
    public EventStrategy newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm algorithm, FormItem formItem) {
        Dialog currentDialog = algorithm == null ? null : algorithm.getDialog();
        return new FormLevelRecognitionEventStrategy(ctx, interpreter, algorithm, currentDialog);
    }
}

