/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.event.EventFilter;

final class HighestCountEventTypeFilter
implements EventFilter {
    private static final Logger LOGGER = LogManager.getLogger(HighestCountEventTypeFilter.class);

    HighestCountEventTypeFilter() {
    }

    @Override
    public void filter(Collection<EventStrategy> strategies, JVoiceXMLEvent event, CatchContainer item) {
        int max = this.getHighestCount(strategies);
        ArrayList<EventStrategy> matchingStrategies = new ArrayList<EventStrategy>();
        for (EventStrategy strategy : strategies) {
            if (strategy.getCount() != max) continue;
            matchingStrategies.add(strategy);
        }
        strategies.retainAll(matchingStrategies);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + matchingStrategies.size() + " event strategies with count " + max);
        }
    }

    private int getHighestCount(Collection<EventStrategy> col) {
        int max = 0;
        for (EventStrategy strategy : col) {
            int count = strategy.getCount();
            if (count <= max) continue;
            max = count;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("highest count for event strategies is " + max);
        }
        return max;
    }
}

