/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.plain.implementation.NomatchEvent;
import org.jvoicexml.event.plain.implementation.RecognitionEvent;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.event.AbstractInputItemEventStrategy;
import org.jvoicexml.interpreter.event.EventStrategyPrototype;
import org.jvoicexml.interpreter.formitem.FieldFormItem;
import org.jvoicexml.interpreter.scope.Scope;

final class InputItemRecognitionEventStrategy
extends AbstractInputItemEventStrategy<FieldFormItem>
implements EventStrategyPrototype {
    private static final Logger LOGGER = LogManager.getLogger(InputItemRecognitionEventStrategy.class);

    InputItemRecognitionEventStrategy() {
    }

    public InputItemRecognitionEventStrategy(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm algorithm, FormItem formItem) {
        super(ctx, interpreter, algorithm, formItem, RecognitionEvent.EVENT_TYPE);
    }

    private void setApplicationLastResult(RecognitionResult result) throws SemanticError {
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        DataModel model = context.getDataModel();
        model.resizeArray("lastresult$", 1, Scope.APPLICATION);
        Object value = model.readArray("lastresult$", 0, Scope.APPLICATION, Object.class);
        model.createVariableFor(value, "confidence", Float.valueOf(result.getConfidence()));
        model.createVariableFor(value, "utterance", result.getUtterance());
        model.createVariableFor(value, "inputmode", result.getMode().name());
        model.createVariableFor(value, "interpretation", result.getSemanticInterpretation(model));
        model.updateArray("lastresult$", 0, value, Scope.APPLICATION);
        model.createVariable("lastresult$.interpretation", result.getSemanticInterpretation(model), Scope.APPLICATION);
        model.createVariable("lastresult$.confidence", Float.valueOf(result.getConfidence()), Scope.APPLICATION);
        model.createVariable("lastresult$.utterance", result.getUtterance(), Scope.APPLICATION);
        model.createVariable("lastresult$.inputmode", result.getMode().name(), Scope.APPLICATION);
    }

    @Override
    protected boolean handleEvent(FieldFormItem field, JVoiceXMLEvent event) throws JVoiceXMLEvent {
        float level;
        RecognitionEvent recognitionEvent = (RecognitionEvent)event;
        RecognitionResult result = recognitionEvent.getRecognitionResult();
        this.setApplicationLastResult(result);
        VoiceXmlInterpreterContext ctx = this.getVoiceXmlInterpreterContext();
        String confidencelevel = ctx.getProperty("confidencelevel", "0.5");
        try {
            level = Float.parseFloat(confidencelevel);
        }
        catch (Exception e) {
            throw new SemanticError("The <property>'s confidencelevel '" + confidencelevel + "'could not be parsed.", e);
        }
        if (result.getConfidence() < level) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result not accepted: confidence was too low: expected: " + level + ", " + "actual: " + result.getConfidence());
            }
            throw new NomatchEvent(recognitionEvent.getSource(), recognitionEvent.getSessionId(), result);
        }
        if (!result.isAccepted()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("result not accepted");
            }
            return false;
        }
        return true;
    }

    @Override
    public EventStrategy newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem item) {
        return new InputItemRecognitionEventStrategy(ctx, interpreter, fia, item);
    }
}

