/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.plain.CancelEvent;
import org.jvoicexml.event.plain.HelpEvent;
import org.jvoicexml.event.plain.implementation.NomatchEvent;
import org.jvoicexml.event.plain.implementation.RecognitionEvent;
import org.jvoicexml.event.plain.jvxml.InputEvent;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.Dialog;
import org.jvoicexml.interpreter.EventCountable;
import org.jvoicexml.interpreter.EventHandler;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.event.AbstractEventStrategy;
import org.jvoicexml.interpreter.event.CatchEventStrategy;
import org.jvoicexml.interpreter.event.ConditionEventTypeFilter;
import org.jvoicexml.interpreter.event.DefaultCancelEventStrategy;
import org.jvoicexml.interpreter.event.DefaultRepromptEventStrategy;
import org.jvoicexml.interpreter.event.EventCountTypeFilter;
import org.jvoicexml.interpreter.event.EventFilter;
import org.jvoicexml.interpreter.event.EventStrategyDecoratorFactory;
import org.jvoicexml.interpreter.event.EventTypeFilter;
import org.jvoicexml.interpreter.event.HighestCountEventTypeFilter;
import org.jvoicexml.interpreter.formitem.InitialFormItem;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopedCollection;
import org.jvoicexml.xml.TokenList;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.AbstractCatchElement;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JVoiceXmlEventHandler
implements EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlEventHandler.class);
    private final EventStrategyDecoratorFactory inputItemFactory;
    private JVoiceXMLEvent event;
    private final Collection<EventFilter> filters;
    private final Collection<EventFilter> filtersNoinput;
    private final ScopedCollection<EventStrategy> strategies;
    private final Object semaphore;
    private final DataModel model;

    public JVoiceXmlEventHandler(DataModel dataModel, ScopeObserver observer) {
        this.strategies = new ScopedCollection(observer);
        this.inputItemFactory = new EventStrategyDecoratorFactory();
        this.semaphore = new Object();
        this.filters = new ArrayList<EventFilter>();
        this.filters.add(new EventTypeFilter());
        this.filters.add(new ConditionEventTypeFilter());
        this.filters.add(new EventCountTypeFilter());
        this.filters.add(new HighestCountEventTypeFilter());
        this.filtersNoinput = new ArrayList<EventFilter>();
        this.filtersNoinput.add(new EventTypeFilter());
        this.model = dataModel;
    }

    Collection<EventStrategy> getStrategies() {
        return this.strategies;
    }

    @Override
    public void collect(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, VoiceXmlDocument document) {
        Vxml vxml = document.getVxml();
        ArrayList<AbstractCatchElement> catches = new ArrayList<AbstractCatchElement>();
        NodeList children = vxml.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof AbstractCatchElement)) continue;
            AbstractCatchElement catchElement = (AbstractCatchElement)child;
            catches.add(catchElement);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + catches.size() + " catch elements in document");
        }
        FormInterpretationAlgorithm fia = interpreter == null ? null : interpreter.getFormInterpretationAlgorithm();
        for (AbstractCatchElement catchElement : catches) {
            TokenList events = catchElement.getEventList();
            for (String eventType : events) {
                this.addCustomEvents(context, interpreter, fia, null, catchElement, eventType);
            }
        }
    }

    @Override
    public void collect(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, Dialog dialog) {
        Collection<AbstractCatchElement> catches = dialog.getCatchElements();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + catches.size() + " catch elements in dialog '" + dialog.getId() + "'");
        }
        FormInterpretationAlgorithm fia = interpreter.getFormInterpretationAlgorithm();
        for (AbstractCatchElement catchElement : catches) {
            TokenList events = catchElement.getEventList();
            for (String eventType : events) {
                this.addCustomEvents(context, interpreter, fia, null, catchElement, eventType);
            }
        }
    }

    @Override
    public Collection<EventStrategy> collect(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, CatchContainer item) {
        ArrayList<EventStrategy> added = new ArrayList<EventStrategy>();
        Collection<AbstractCatchElement> catches = item.getCatchElements();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found " + catches.size() + " catch elements in item '" + item.getName() + "'");
        }
        for (AbstractCatchElement catchElement : catches) {
            TokenList events = catchElement.getEventList();
            for (String eventType : events) {
                if (eventType.equals("filled") && item instanceof InitialFormItem) {
                    LOGGER.warn("Initial form items must not have catches for filled: ignoring...");
                    continue;
                }
                EventStrategy strategy = this.addCustomEvents(context, interpreter, fia, item, catchElement, eventType);
                added.add(strategy);
            }
        }
        Collection<EventStrategy> defaultStrategies = this.addDefaultStrategies(context, interpreter, fia, item);
        added.addAll(defaultStrategies);
        EventStrategy itemStrategy = this.inputItemFactory.getDecorator(context, interpreter, fia, item);
        boolean add = this.addStrategy(itemStrategy);
        if (add) {
            added.add(itemStrategy);
        }
        return added;
    }

    private EventStrategy addCustomEvents(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem item, AbstractCatchElement catchElement, String eventType) {
        CatchEventStrategy strategy = new CatchEventStrategy(context, interpreter, fia, item, (VoiceXmlNode)catchElement, eventType);
        this.addStrategy(strategy);
        return strategy;
    }

    private Collection<EventStrategy> addDefaultStrategies(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, CatchContainer item) {
        AbstractEventStrategy strategy;
        boolean add;
        ArrayList<EventStrategy> added = new ArrayList<EventStrategy>();
        if (!this.containsStrategy("noinput") && (add = this.addStrategy(strategy = new DefaultRepromptEventStrategy(context, interpreter, fia, item, "noinput")))) {
            added.add(strategy);
        }
        if (!this.containsStrategy("nomatch") && (add = this.addStrategy(strategy = new DefaultRepromptEventStrategy(context, interpreter, fia, item, "nomatch")))) {
            added.add(strategy);
        }
        if (!this.containsStrategy("help") && (add = this.addStrategy(strategy = new DefaultRepromptEventStrategy(context, interpreter, fia, item, "help")))) {
            added.add(strategy);
        }
        if (!this.containsStrategy("cancel") && (add = this.addStrategy(strategy = new DefaultCancelEventStrategy(context, interpreter, fia, item, "cancel")))) {
            added.add(strategy);
        }
        return added;
    }

    @Override
    public boolean addStrategy(EventStrategy strategy) {
        if (strategy == null) {
            LOGGER.debug("can not add a null strategy");
            return false;
        }
        if (this.strategies.contains(strategy)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("strategy: '" + strategy.getClass() + "' for event type '" + strategy.getEventType() + "'" + " ignored since it is already registered");
            }
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("adding strategy: '" + strategy.getClass() + "' for event type '" + strategy.getEventType() + "'");
        }
        return this.strategies.add(strategy);
    }

    @Override
    public void clean(FormItem item) {
        ArrayList<AbstractEventStrategy> toremove = new ArrayList<AbstractEventStrategy>();
        for (EventStrategy strategy : this.strategies) {
            AbstractEventStrategy eventStrategy;
            FormItem strategyItem;
            if (!(strategy instanceof AbstractEventStrategy) || item != (strategyItem = (eventStrategy = (AbstractEventStrategy)strategy).getFormItem())) continue;
            toremove.add(eventStrategy);
        }
        this.strategies.removeAll(toremove);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("removed " + toremove.size() + " event strategies for form item '" + item.getName() + "'");
        }
    }

    private EventStrategy getStrategy(String type) {
        for (EventStrategy strategy : this.strategies) {
            String currentType = strategy.getEventType();
            if (!currentType.equals(type)) continue;
            return strategy;
        }
        return null;
    }

    private boolean containsStrategy(String type) {
        EventStrategy strategy = this.getStrategy(type);
        return strategy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JVoiceXMLEvent waitEvent() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("waiting for an event...");
        }
        while (this.event == null) {
            try {
                Object object = this.semaphore;
                synchronized (object) {
                    if (this.event == null) {
                        this.semaphore.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                LOGGER.error("wait event was interrupted", (Throwable)ie);
                return null;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("received event: " + this.event);
        }
        try {
            this.event = this.transformEvent(this.event);
        }
        catch (SemanticError e) {
            LOGGER.warn("unable to transform event", (Throwable)e);
        }
        return this.event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(CatchContainer item) throws JVoiceXMLEvent {
        if (this.event == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no event: nothing to do");
            }
            return;
        }
        if (item instanceof EventCountable) {
            EventCountable countable = (EventCountable)((Object)item);
            countable.incrementEventCounter(this.event);
        }
        String type = this.event.getEventType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("processing event of type '" + type + "'...");
        }
        ArrayList<EventStrategy> matchingStrategies = new ArrayList<EventStrategy>(this.strategies);
        Collection<EventFilter> eventFilters = item == null ? this.filtersNoinput : this.filters;
        for (EventFilter filter : eventFilters) {
            filter.filter(matchingStrategies, this.event, item);
            if (!matchingStrategies.isEmpty()) continue;
            LOGGER.info("no matching strategy for type '" + type + "'");
            JVoiceXMLEvent copy = this.event;
            this.event = null;
            throw copy;
        }
        Iterator iterator = matchingStrategies.iterator();
        EventStrategy strategy = (EventStrategy)iterator.next();
        try {
            strategy.process(this.event);
        }
        catch (NomatchEvent e) {
            this.event = e;
            this.processEvent(item);
        }
        finally {
            this.event = null;
        }
    }

    @Override
    public void clearEvent() {
        this.event = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onEvent(JVoiceXMLEvent e) {
        if (e == null) {
            return;
        }
        String type = e.getEventType();
        if (!(e instanceof InputEvent) && type.startsWith("org.jvoicexml.event.plain.implementation")) {
            return;
        }
        if (this.event != null) {
            LOGGER.info("ignoring second event '" + type + "' current  event is '" + this.event.getEventType() + "'");
            return;
        }
        Object object = this.semaphore;
        synchronized (object) {
            try {
                this.event = e;
                LOGGER.info("notified event '" + this.event.getEventType() + "'");
            }
            finally {
                this.semaphore.notify();
            }
        }
    }

    private JVoiceXMLEvent transformEvent(JVoiceXMLEvent e) throws SemanticError {
        if (!(e instanceof RecognitionEvent)) {
            return e;
        }
        RecognitionEvent recevent = (RecognitionEvent)e;
        RecognitionResult result = recevent.getRecognitionResult();
        Object interpretation = result.getSemanticInterpretation(this.model);
        if (interpretation == null) {
            return e;
        }
        if (interpretation.equals("help")) {
            LOGGER.info("sematic interpretation of the recognition result is a help request");
            return new HelpEvent();
        }
        if (interpretation.equals("cancel")) {
            LOGGER.info("sematic interpretation of the recognition result is a cancel request");
            return new CancelEvent();
        }
        return e;
    }

    @Override
    public JVoiceXMLEvent getEvent() {
        return this.event;
    }

    @Override
    public boolean removeStrategies(Collection<EventStrategy> strats) {
        if (strats == null) {
            return false;
        }
        return this.strategies.removeAll(strats);
    }
}

