/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.event;

import java.io.ByteArrayInputStream;
import java.net.URI;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallControl;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.Session;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;
import org.jvoicexml.event.plain.implementation.RecordingStoppedEvent;
import org.jvoicexml.event.plain.jvxml.RecordingEvent;
import org.jvoicexml.interpreter.EventStrategy;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.event.AbstractInputItemEventStrategy;
import org.jvoicexml.interpreter.event.EventStrategyPrototype;
import org.jvoicexml.interpreter.formitem.RecordFormItem;

final class RecordingEventStrategy
extends AbstractInputItemEventStrategy<RecordFormItem>
implements EventStrategyPrototype {
    private static final Logger LOGGER = LogManager.getLogger(RecordingEventStrategy.class);
    private final AudioFormat format;

    RecordingEventStrategy() {
        this.format = null;
    }

    public RecordingEventStrategy(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm algorithm, FormItem formItem, AudioFormat recordingFormat) {
        super(ctx, interpreter, algorithm, formItem, RecordingEvent.EVENT_TYPE);
        this.format = recordingFormat;
    }

    @Override
    protected boolean handleEvent(RecordFormItem record, JVoiceXMLEvent event) throws JVoiceXMLEvent {
        RecordingEvent recordingEvent = (RecordingEvent)event;
        byte[] buffer = recordingEvent.getRecordingBuffer();
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        VoiceXmlInterpreterContext context = this.getVoiceXmlInterpreterContext();
        DocumentServer server = context.getDocumentServer();
        long length = buffer.length / this.format.getFrameSize();
        AudioInputStream ain = new AudioInputStream(in, this.format, length);
        URI result = server.storeAudio(ain);
        recordingEvent.setInputResult(result);
        Session session = context.getSession();
        RecordingStoppedEvent stopped = new RecordingStoppedEvent(session.getSessionId(), result);
        EventBus bus = context.getEventBus();
        bus.publish(stopped);
        return true;
    }

    @Override
    public EventStrategy newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem item) {
        AudioFormat audioFormat;
        ImplementationPlatform platform = ctx.getImplementationPlatform();
        CallControl call = null;
        try {
            call = platform.getCallControl();
        }
        catch (NoresourceError e) {
            LOGGER.error("unable to obtain call control", (Throwable)e);
        }
        catch (ConnectionDisconnectHangupEvent e) {
            LOGGER.error("unable to obtain call control", (Throwable)e);
        }
        if (call == null) {
            LOGGER.warn("no active call control. can not set audio format");
            audioFormat = null;
        } else {
            audioFormat = call.getRecordingAudioFormat();
        }
        RecordFormItem record = (RecordFormItem)item;
        return new RecordingEventStrategy(ctx, interpreter, fia, (FormItem)record, audioFormat);
    }
}

