/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.FormItemLocalExecutableTagContainer;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.FormItemNameFactory;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.AbstractCatchElement;
import org.jvoicexml.xml.vxml.Property;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractFormItem
implements FormItem,
FormItemLocalExecutableTagContainer {
    private static final Logger LOGGER = LogManager.getLogger(AbstractFormItem.class);
    private final VoiceXmlInterpreterContext context;
    private final VoiceXmlNode node;
    private final String name;

    AbstractFormItem() {
        this.node = null;
        this.context = null;
        this.name = null;
    }

    AbstractFormItem(VoiceXmlInterpreterContext ctx, VoiceXmlNode voiceNode) {
        this.node = voiceNode;
        this.context = ctx;
        this.name = FormItemNameFactory.getName(this.node);
    }

    public abstract AbstractFormItem newInstance(VoiceXmlInterpreterContext var1, VoiceXmlNode var2);

    @Override
    public final Object getFormItemVariable() {
        DataModel model = this.context.getDataModel();
        try {
            return model.readVariable(this.name, Object.class);
        }
        catch (SemanticError ignore) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("retrieved undefined form item variable");
            }
            return null;
        }
    }

    @Override
    public int setFormItemVariable(Object value) throws SemanticError {
        DataModel model = this.context.getDataModel();
        return model.updateVariable(this.name, value);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Object evaluateExpression(DataModel model) throws SemanticError {
        String expr = this.node.getAttribute("expr");
        String unescapedExpr = StringEscapeUtils.unescapeXml((String)expr);
        return model.evaluateExpression(unescapedExpr, Object.class);
    }

    @Override
    public boolean evaluateCondition() throws SemanticError {
        String condAttribute = this.node.getAttribute("cond");
        if (condAttribute == null) {
            return true;
        }
        String unescapedCond = StringEscapeUtils.unescapeXml((String)condAttribute);
        DataModel model = this.context.getDataModel();
        return model.evaluateExpression(unescapedCond, Boolean.class);
    }

    @Override
    public boolean isSelectable() throws SemanticError {
        boolean selectable;
        Object result = this.getFormItemVariable();
        boolean cond = this.evaluateCondition();
        DataModel model = this.context.getDataModel();
        boolean bl = selectable = (result == model.getUndefinedValue() || result == null) && cond;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checking if selectable");
            String logResult = model.toString(result);
            LOGGER.debug("value of   '" + this.name + "': '" + logResult + "'");
            LOGGER.debug("cond of    '" + this.name + "': '" + cond + "'");
            LOGGER.debug("selectable '" + this.name + "': " + selectable);
        }
        return selectable;
    }

    @Override
    public final VoiceXmlNode getNode() {
        return this.node;
    }

    @Override
    public final String getNodeTagName() {
        if (this.node == null) {
            return null;
        }
        return this.node.getTagName();
    }

    protected final VoiceXmlInterpreterContext getContext() {
        return this.context;
    }

    public Collection<AbstractCatchElement> getCatchElements() {
        if (this.node == null) {
            return null;
        }
        ArrayList<AbstractCatchElement> catches = new ArrayList<AbstractCatchElement>();
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof AbstractCatchElement)) continue;
            AbstractCatchElement catchElement = (AbstractCatchElement)child;
            catches.add(catchElement);
        }
        return catches;
    }

    @Override
    public Collection<VoiceXmlNode> getLocalExecutableTags() {
        if (this.node == null) {
            return null;
        }
        ArrayList<VoiceXmlNode> nodes = new ArrayList<VoiceXmlNode>();
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Property)) continue;
            VoiceXmlNode voiceXmlNode = (VoiceXmlNode)child;
            nodes.add(voiceXmlNode);
        }
        return nodes;
    }
}

