/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.interpreter.GrammarContainer;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.formitem.AbstractInputItem;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.srgs.Grammar;

abstract class AbstractGrammarContainer
extends AbstractInputItem
implements GrammarContainer {
    private static final Logger LOGGER = LogManager.getLogger(AbstractGrammarContainer.class);
    private final Set<GrammarDocument> documents;
    private Collection<Grammar> grammars;

    AbstractGrammarContainer() {
        this.documents = null;
    }

    AbstractGrammarContainer(VoiceXmlInterpreterContext context, VoiceXmlNode voiceNode) {
        super(context, voiceNode);
        this.documents = new HashSet<GrammarDocument>();
    }

    @Override
    public Collection<GrammarDocument> getGrammarDocuments() {
        return this.documents;
    }

    @Override
    public void addGrammar(GrammarDocument document) {
        if (this.documents.add(document) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("added grammar " + document + " for field '" + this.getName() + "'");
        }
    }

    protected void addCustomGrammars(Collection<Grammar> grams) {
    }

    @Override
    public final Collection<Grammar> getGrammars() {
        VoiceXmlNode node = this.getNode();
        if (node == null) {
            return null;
        }
        if (this.grammars == null) {
            this.grammars = node.getChildNodes(Grammar.class);
            this.addCustomGrammars(this.grammars);
        }
        return this.grammars;
    }
}

