/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.EventCountable;
import org.jvoicexml.interpreter.InputItem;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.interpreter.formitem.EventCounter;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Filled;

abstract class AbstractInputItem
extends AbstractFormItem
implements InputItem {
    private static final Logger LOGGER = LogManager.getLogger(AbstractInputItem.class);
    private final EventCountable eventCounter;
    private int promptCounter;

    AbstractInputItem() {
        this.eventCounter = null;
        this.promptCounter = 0;
    }

    AbstractInputItem(VoiceXmlInterpreterContext context, VoiceXmlNode voiceNode) {
        super(context, voiceNode);
        this.eventCounter = new EventCounter();
        this.promptCounter = 1;
    }

    @Override
    public final void incrementEventCounter(JVoiceXMLEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("incrementing event counter for '" + this.getName() + "'...");
        }
        this.eventCounter.incrementEventCounter(event);
    }

    @Override
    public final void resetEventCounter() {
        this.eventCounter.resetEventCounter();
        if (LOGGER.isDebugEnabled()) {
            String name = this.getName();
            LOGGER.debug("resetted event counter for input item '" + name + "'...");
        }
    }

    @Override
    public final int getPromptCount() {
        return this.promptCounter;
    }

    @Override
    public final void incrementPromptCount() {
        ++this.promptCounter;
    }

    @Override
    public final void resetPromptCount() {
        this.promptCounter = 1;
        if (LOGGER.isDebugEnabled()) {
            String name = this.getName();
            LOGGER.debug("initialized prompt counter for input item '" + name + "'");
        }
    }

    @Override
    public final int getEventCount(String type) {
        return this.eventCounter.getEventCount(type);
    }

    protected final String getShadowVarContainerName() {
        StringBuilder str = new StringBuilder();
        String name = this.getName();
        str.append(name);
        str.append('$');
        return str.toString();
    }

    @Override
    public final Collection<Filled> getFilledElements() {
        VoiceXmlNode node = this.getNode();
        if (node == null) {
            return null;
        }
        return node.getChildNodes(Filled.class);
    }

    @Override
    public void init(DataModel model) throws SemanticError, BadFetchError {
        String name = this.getName();
        Object expression = this.evaluateExpression(model);
        model.createVariable(name, expression);
        String shadowVariableName = this.getShadowVarContainerName();
        model.createVariable(shadowVariableName);
        LOGGER.info("initialized input form item '" + name + "' with '" + expression + "'");
        this.resetPromptCount();
        this.resetEventCounter();
    }
}

