/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.FormItemVisitor;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.AbstractControlItem;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.AbstractCatchElement;
import org.jvoicexml.xml.vxml.Block;

public final class BlockFormItem
extends AbstractControlItem {
    private static final Logger LOGGER = LogManager.getLogger(BlockFormItem.class);

    public BlockFormItem() {
    }

    public BlockFormItem(VoiceXmlInterpreterContext context, VoiceXmlNode voiceNode) throws IllegalArgumentException {
        super(context, voiceNode);
        if (!(voiceNode instanceof Block)) {
            throw new IllegalArgumentException("Node must be a <block>");
        }
    }

    @Override
    public AbstractFormItem newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlNode voiceNode) {
        return new BlockFormItem(ctx, voiceNode);
    }

    public void setVisited() {
        try {
            int rc = this.setFormItemVariable(Boolean.TRUE);
            if (rc == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("block '" + this.getName() + "' marked as visited.");
                }
            } else {
                LOGGER.warn("unable to mark block '" + this.getName() + "' as visited (rc=" + rc + ")");
            }
        }
        catch (SemanticError e) {
            LOGGER.error("error marking '" + this.getName() + "' as visited", (Throwable)e);
        }
    }

    @Override
    public void accept(FormItemVisitor visitor) throws JVoiceXMLEvent {
        visitor.visitBlockFormItem(this);
    }

    @Override
    public Collection<AbstractCatchElement> getCatchElements() {
        return null;
    }

    @Override
    public boolean isModal() {
        return false;
    }

    @Override
    public void init(DataModel model) throws SemanticError, BadFetchError {
        String name = this.getName();
        Object expression = this.evaluateExpression(model);
        model.createVariable(name, expression);
        LOGGER.info("initialized block form item '" + name + "' with '" + expression + "'");
    }
}

