/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.interpreter.EventCountable;

final class EventCounter
implements EventCountable {
    private static final Logger LOGGER = LogManager.getLogger(EventCounter.class);
    private final Map<String, Integer> counter = new HashMap<String, Integer>();

    EventCounter() {
    }

    @Override
    public void incrementEventCounter(JVoiceXMLEvent event) {
        Collection<String> prefixes = this.getPrefixes(event.getEventType());
        for (String prefix : prefixes) {
            Integer count = this.counter.get(prefix);
            if (count == null) {
                count = new Integer(0);
            }
            this.counter.put(prefix, count + 1);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("incremented count of '" + prefix + "' to " + this.counter.get(prefix));
        }
    }

    private Collection<String> getPrefixes(String type) {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add(type);
        String prefix = type;
        int dot = prefix.lastIndexOf(".");
        while (dot > 0) {
            prefix = prefix.substring(0, dot);
            prefixes.add(prefix);
            dot = prefix.lastIndexOf(".");
        }
        return prefixes;
    }

    @Override
    public int getEventCount(String type) {
        Integer count = this.counter.get(type);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public void resetEventCounter() {
        this.counter.clear();
    }
}

