/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.Collection;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.LastResult;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.FormItemVisitor;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.interpreter.formitem.AbstractGrammarContainer;
import org.jvoicexml.interpreter.formitem.OptionConverter;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.vxml.Field;
import org.jvoicexml.xml.vxml.Option;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;

public final class FieldFormItem
extends AbstractGrammarContainer {
    private static final Logger LOGGER = LogManager.getLogger(FieldFormItem.class);
    private OptionConverter converter;

    public FieldFormItem() {
    }

    public FieldFormItem(VoiceXmlInterpreterContext context, VoiceXmlNode voiceNode) throws IllegalArgumentException {
        super(context, voiceNode);
        if (!(voiceNode instanceof Field)) {
            throw new IllegalArgumentException("Node must be a <field>");
        }
    }

    @Override
    public AbstractFormItem newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlNode voiceNode) {
        return new FieldFormItem(ctx, voiceNode);
    }

    public void setOptionConverter(OptionConverter optionConverter) {
        this.converter = optionConverter;
    }

    @Override
    public void accept(FormItemVisitor visitor) throws JVoiceXMLEvent {
        visitor.visitFieldFormItem(this);
    }

    public int setFormItemVariable(RecognitionResult result) throws SemanticError {
        VoiceXmlInterpreterContext context = this.getContext();
        DataModel model = context.getDataModel();
        String shadowVariableName = this.getShadowVarContainerName();
        LastResult lastresult = this.toLastResult(model, result);
        model.updateVariable(shadowVariableName, lastresult);
        Object interpretation = result.getSemanticInterpretation(model);
        if (interpretation == null) {
            String utterance = result.getUtterance();
            return super.setFormItemVariable(utterance);
        }
        String slot = this.getSlot();
        String slotPath = "application.lastresult$.interpretation." + slot;
        if (model.existsVariable(slotPath)) {
            Object value = model.readVariable(slotPath, Object.class);
            return super.setFormItemVariable(value);
        }
        return super.setFormItemVariable(interpretation);
    }

    public int setFormItemVariable(String utterance) throws SemanticError {
        VoiceXmlInterpreterContext context = this.getContext();
        DataModel model = context.getDataModel();
        String shadowVariableName = this.getShadowVarContainerName();
        LastResult lastresult = new LastResult(utterance);
        model.updateVariable(shadowVariableName, lastresult);
        return super.setFormItemVariable(utterance);
    }

    private LastResult toLastResult(DataModel model, RecognitionResult result) throws SemanticError {
        String utterance = result.getUtterance();
        float confidence = result.getConfidence();
        ModeType mode = result.getMode();
        Object interpretation = result.getSemanticInterpretation(model);
        return new LastResult(utterance, confidence, mode.getMode(), interpretation);
    }

    @Override
    public int setFormItemVariable(Object value) throws SemanticError {
        if (value instanceof RecognitionResult) {
            RecognitionResult result = (RecognitionResult)value;
            return this.setFormItemVariable(result);
        }
        String utterance = value.toString();
        return this.setFormItemVariable(utterance);
    }

    private Field getField() {
        VoiceXmlNode node = this.getNode();
        if (node == null) {
            return null;
        }
        return (Field)node;
    }

    @Override
    protected void addCustomGrammars(Collection<Grammar> grammars) {
        Field field = this.getField();
        VoiceXmlDocument document = (VoiceXmlDocument)field.getOwnerXmlDocument(VoiceXmlDocument.class);
        Vxml vxml = document.getVxml();
        Locale locale = vxml.getXmlLangObject();
        this.addCustomBuiltinGrammars(grammars, field, locale);
        this.addCustomOptionGrammars(grammars, field, locale);
    }

    private void addCustomBuiltinGrammars(Collection<Grammar> grammars, Field field, Locale locale) {
        String type = field.getType();
        if (type == null) {
            return;
        }
        if (type.startsWith("builtin:")) {
            Grammar grammar = this.addCustomGrammar(field, type, locale);
            grammars.add(grammar);
        } else {
            Grammar dtmfGrammar = this.addCustomGrammar(field, "builtin:dtmf/" + type, locale);
            dtmfGrammar.setMode(ModeType.DTMF);
            grammars.add(dtmfGrammar);
            Grammar voiceGrammar = this.addCustomGrammar(field, "builtin:voice/" + type, locale);
            voiceGrammar.setMode(ModeType.VOICE);
            grammars.add(voiceGrammar);
        }
    }

    private void addCustomOptionGrammars(Collection<Grammar> grammars, Field field, Locale locale) {
        Grammar optionDtmfGrammar;
        Collection options = field.getChildNodes(Option.class);
        if (options.isEmpty()) {
            return;
        }
        if (this.converter == null) {
            if (!options.isEmpty()) {
                LOGGER.warn("no converter defined. unable to process options");
            }
            return;
        }
        Grammar optionVoiceGrammar = this.converter.createVoiceGrammar(options, locale);
        if (optionVoiceGrammar != null) {
            grammars.add(optionVoiceGrammar);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("added voice grammar from options: " + optionVoiceGrammar);
            }
        }
        if ((optionDtmfGrammar = this.converter.createDtmfGrammar(options)) != null) {
            grammars.add(optionDtmfGrammar);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("added DTMF grammar from options: " + optionDtmfGrammar);
            }
        }
    }

    private Grammar addCustomGrammar(Field field, String type, Locale language) {
        Grammar grammar = (Grammar)field.appendChild(Grammar.class);
        grammar.setSrc(type);
        grammar.setXmlLang(language);
        grammar.setType(GrammarType.SRGS_XML);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added builtin grammar '" + grammar.getSrc() + "'");
        }
        return grammar;
    }

    public String getSlot() {
        Field field = this.getField();
        String slot = field.getSlot();
        if (slot != null) {
            return slot;
        }
        return field.getName();
    }

    @Override
    public boolean isModal() {
        Field field = this.getField();
        if (field == null) {
            return false;
        }
        return field.isModal();
    }
}

