/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.HashMap;
import java.util.Map;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.interpreter.formitem.BlockFormItem;
import org.jvoicexml.interpreter.formitem.FieldFormItem;
import org.jvoicexml.interpreter.formitem.InitialFormItem;
import org.jvoicexml.interpreter.formitem.ObjectFormItem;
import org.jvoicexml.interpreter.formitem.RecordFormItem;
import org.jvoicexml.interpreter.formitem.SubdialogFormItem;
import org.jvoicexml.interpreter.formitem.TransferFormItem;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Block;
import org.jvoicexml.xml.vxml.Field;
import org.jvoicexml.xml.vxml.Initial;
import org.jvoicexml.xml.vxml.ObjectTag;
import org.jvoicexml.xml.vxml.Record;
import org.jvoicexml.xml.vxml.Subdialog;
import org.jvoicexml.xml.vxml.Transfer;

public final class FormItemFactory {
    private static final Map<Class<?>, AbstractFormItem> FORM_ITEMS = new HashMap();

    private FormItemFactory() {
    }

    public static AbstractFormItem getFormItem(VoiceXmlInterpreterContext context, VoiceXmlNode node) {
        Class<?> clazz = node.getClass();
        AbstractFormItem template = FORM_ITEMS.get(clazz);
        if (template == null) {
            return null;
        }
        return template.newInstance(context, node);
    }

    static {
        FORM_ITEMS.put(Block.class, new BlockFormItem());
        FORM_ITEMS.put(Block.class, new BlockFormItem());
        FORM_ITEMS.put(Initial.class, new InitialFormItem());
        FORM_ITEMS.put(Field.class, new FieldFormItem());
        FORM_ITEMS.put(ObjectTag.class, new ObjectFormItem());
        FORM_ITEMS.put(Record.class, new RecordFormItem());
        FORM_ITEMS.put(Subdialog.class, new SubdialogFormItem());
        FORM_ITEMS.put(Transfer.class, new TransferFormItem());
    }
}

