/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.CatchContainer;
import org.jvoicexml.interpreter.EventCountable;
import org.jvoicexml.interpreter.FormItemVisitor;
import org.jvoicexml.interpreter.PromptCountable;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.AbstractControlItem;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.interpreter.formitem.EventCounter;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Initial;

public final class InitialFormItem
extends AbstractControlItem
implements CatchContainer,
PromptCountable,
EventCountable {
    private static final Logger LOGGER = LogManager.getLogger(InitialFormItem.class);
    private int promptCounter;
    private final EventCountable eventCounter;

    public InitialFormItem() {
        this.eventCounter = null;
        this.promptCounter = 0;
    }

    public InitialFormItem(VoiceXmlInterpreterContext context, VoiceXmlNode voiceNode) throws IllegalArgumentException {
        super(context, voiceNode);
        if (!(voiceNode instanceof Initial)) {
            throw new IllegalArgumentException("Node must be a <initial>");
        }
        this.eventCounter = new EventCounter();
        this.promptCounter = 1;
    }

    @Override
    public AbstractFormItem newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlNode voiceNode) {
        return new InitialFormItem(ctx, voiceNode);
    }

    @Override
    public void accept(FormItemVisitor visitor) throws JVoiceXMLEvent {
        visitor.visitInitialFormItem(this);
    }

    @Override
    public boolean isModal() {
        return false;
    }

    @Override
    public int getPromptCount() {
        return this.promptCounter;
    }

    @Override
    public void incrementPromptCount() {
        ++this.promptCounter;
    }

    @Override
    public void resetPromptCount() {
        this.promptCounter = 1;
    }

    @Override
    public int getEventCount(String type) {
        return this.eventCounter.getEventCount(type);
    }

    @Override
    public void incrementEventCounter(JVoiceXMLEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("incrementing event counter for '" + this.getName() + "'...");
        }
        this.eventCounter.incrementEventCounter(event);
    }

    @Override
    public void resetEventCounter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resetting event counter for initial item '" + this.getName() + "'...");
        }
        this.eventCounter.resetEventCounter();
    }

    @Override
    public void init(DataModel model) throws SemanticError, BadFetchError {
        String name = this.getName();
        Object expression = this.evaluateExpression(model);
        model.createVariable(name, expression);
        LOGGER.info("initialized initial form item '" + name + "' with '" + expression + "'");
        this.resetPromptCount();
        this.resetEventCounter();
    }
}

