/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import java.util.Collection;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.formitem.OptionConverter;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.Item;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.OneOf;
import org.jvoicexml.xml.srgs.Rule;
import org.jvoicexml.xml.srgs.SrgsXmlDocument;
import org.jvoicexml.xml.vxml.Option;

public final class SrgsXmlOptionConverter
implements OptionConverter {
    private static final Logger LOGGER = LogManager.getLogger(SrgsXmlOptionConverter.class);
    private static long sequence = 0L;

    private static synchronized String getName(ModeType type) {
        String leadingZeros = "000000";
        String sequenceString = "000000" + Long.toHexString(++sequence);
        sequenceString = sequenceString.substring(sequenceString.length() - "000000".length());
        return "OG" + type + Long.toHexString(System.currentTimeMillis()) + "S" + sequenceString;
    }

    @Override
    public Grammar createVoiceGrammar(Collection<Option> options, Locale language) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        try {
            SrgsXmlDocument document = new SrgsXmlDocument();
            Grammar grammar = document.getGrammar();
            grammar.setXmlLang(language);
            Rule rule = (Rule)grammar.appendChild(Rule.class);
            String name = SrgsXmlOptionConverter.getName(ModeType.VOICE);
            rule.setId(name);
            grammar.setRoot(rule);
            OneOf oneof = (OneOf)rule.appendChild(OneOf.class);
            for (Option option : options) {
                Item item = (Item)oneof.appendChild(Item.class);
                String text = option.getTextContent();
                item.addText(text);
            }
            return grammar;
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Grammar createDtmfGrammar(Collection<Option> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        try {
            SrgsXmlDocument document = new SrgsXmlDocument();
            Grammar grammar = document.getGrammar();
            Rule rule = (Rule)grammar.appendChild(Rule.class);
            String name = SrgsXmlOptionConverter.getName(ModeType.DTMF);
            rule.setId(name);
            grammar.setRoot(rule);
            OneOf oneof = (OneOf)rule.appendChild(OneOf.class);
            boolean hasDtmf = false;
            for (Option option : options) {
                String dtmf = option.getDtmf();
                if (dtmf == null) continue;
                Item item = (Item)oneof.appendChild(Item.class);
                item.addText(dtmf);
                hasDtmf = true;
            }
            if (hasDtmf) {
                return grammar;
            }
            return null;
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

