/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.formitem;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.FormItemVisitor;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.formitem.AbstractFormItem;
import org.jvoicexml.interpreter.formitem.AbstractGrammarContainer;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.vxml.Transfer;

public final class TransferFormItem
extends AbstractGrammarContainer {
    public TransferFormItem() {
    }

    public TransferFormItem(VoiceXmlInterpreterContext context, VoiceXmlNode voiceNode) throws IllegalArgumentException {
        super(context, voiceNode);
        if (!(voiceNode instanceof Transfer)) {
            throw new IllegalArgumentException("Node must be a <transfer>");
        }
    }

    @Override
    public AbstractFormItem newInstance(VoiceXmlInterpreterContext ctx, VoiceXmlNode voiceNode) {
        return new TransferFormItem(ctx, voiceNode);
    }

    @Override
    public void accept(FormItemVisitor visitor) throws JVoiceXMLEvent {
        visitor.visitTransferFormItem(this);
    }

    public String getDest() throws SemanticError, BadFetchError {
        Transfer transfer = this.getTransfer();
        if (transfer == null) {
            return null;
        }
        String dest = transfer.getDest();
        if (dest != null) {
            return dest;
        }
        dest = transfer.getDestexpr();
        if (dest == null) {
            throw new BadFetchError("Either one of \"dest\" or \"destexpr\" must be specified!");
        }
        String unescapedDestexpr = StringEscapeUtils.unescapeXml((String)dest);
        VoiceXmlInterpreterContext context = this.getContext();
        DataModel model = context.getDataModel();
        return model.evaluateExpression(unescapedDestexpr, String.class);
    }

    public boolean isBridged() {
        Transfer transfer = this.getTransfer();
        if (transfer == null) {
            return false;
        }
        return transfer.isBridge();
    }

    private Transfer getTransfer() {
        VoiceXmlNode node = this.getNode();
        if (node == null) {
            return null;
        }
        return (Transfer)node;
    }

    @Override
    public boolean isModal() {
        return true;
    }
}

