/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.event.error.UnsupportedFormatError;
import org.jvoicexml.interpreter.grammar.GrammarIdentifier;
import org.jvoicexml.xml.srgs.GrammarType;

public final class GrammarIdentifierCentral {
    private final Collection<GrammarIdentifier> identifier = new ArrayList<GrammarIdentifier>();
    private static final Logger LOGGER = LogManager.getLogger(GrammarIdentifierCentral.class);

    public GrammarType identifyGrammar(GrammarDocument grammar, GrammarType expectedType) throws UnsupportedFormatError {
        if (grammar == null) {
            throw new UnsupportedFormatError("Cannot identify a null grammar!");
        }
        if (this.identifier.isEmpty()) {
            LOGGER.warn("no registered identifier!");
            return null;
        }
        GrammarIdentifier expectedIdentifier = this.getIdentifierByType(expectedType);
        if (expectedIdentifier != null) {
            GrammarType type;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("trying to identify grammar with '" + expectedIdentifier.getClass() + "'");
            }
            if ((type = expectedIdentifier.identify(grammar)) != null) {
                return type;
            }
        }
        for (GrammarIdentifier current : this.identifier) {
            GrammarType currentType;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("trying to identify grammar with '" + current.getClass() + "'");
            }
            if (current.getSupportedType() == expectedType || (currentType = current.identify(grammar)) == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("identified grammar with type '" + currentType + "'");
            }
            return currentType;
        }
        LOGGER.warn("unable to identify grammar");
        return null;
    }

    protected List<GrammarIdentifier> getAvailableIdentifier(GrammarType type) {
        ArrayList<GrammarIdentifier> list = new ArrayList<GrammarIdentifier>(this.identifier);
        if (type == null) {
            list.clear();
            LOGGER.warn("no identifiers for null type!");
            return list;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            GrammarIdentifier current = (GrammarIdentifier)it.next();
            GrammarType currentType = current.getSupportedType();
            if (type == currentType) continue;
            it.remove();
        }
        return list;
    }

    public boolean typeSupported(GrammarType type) {
        List<GrammarIdentifier> list = this.getAvailableIdentifier(type);
        return !list.isEmpty();
    }

    public void setIdentifier(List<GrammarIdentifier> grammarIdenifier) {
        for (GrammarIdentifier id : grammarIdenifier) {
            this.addIdentifier(id);
        }
    }

    public void addIdentifier(GrammarIdentifier id) {
        this.identifier.add(id);
        GrammarType type = id.getSupportedType();
        LOGGER.info("added grammar identifier " + id.getClass() + " for type '" + type + "'");
    }

    private GrammarIdentifier getIdentifierByType(GrammarType type) {
        for (GrammarIdentifier current : this.identifier) {
            GrammarType currentType = current.getSupportedType();
            if (type != currentType) continue;
            return current;
        }
        return null;
    }
}

