/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.FetchAttributes;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.Session;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.error.UnsupportedFormatError;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.interpreter.grammar.InternalGrammarDocument;
import org.jvoicexml.xml.IllegalAttributeException;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;

final class GrammarLoader {
    private static final Logger LOGGER = LogManager.getLogger(GrammarLoader.class);

    GrammarLoader() {
    }

    public GrammarDocument loadGrammarDocument(VoiceXmlInterpreterContext context, FetchAttributes attributes, Grammar grammar, Locale language) throws UnsupportedFormatError, BadFetchError, SemanticError {
        try {
            if (grammar.isExternalGrammar()) {
                return this.loadExternalGrammar(context, attributes, grammar);
            }
            Session session = context.getSession();
            String sessionId = session.getSessionId();
            DocumentServer server = context.getDocumentServer();
            return this.loadInternalGrammar(sessionId, server, grammar, language);
        }
        catch (URISyntaxException | IllegalAttributeException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
    }

    private GrammarDocument loadInternalGrammar(String sessionId, DocumentServer server, Grammar grammar, Locale language) throws UnsupportedFormatError, URISyntaxException {
        Locale grammarLanguage;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loading internal grammar");
        }
        if ((grammarLanguage = grammar.getXmlLangObject()) == null) {
            grammar.setXmlLang(language);
        }
        InternalGrammarDocument document = new InternalGrammarDocument(grammar);
        this.adaptGrammarAttributes(grammar, document);
        server.addGrammarDocument(sessionId, document);
        return document;
    }

    private GrammarDocument loadExternalGrammar(VoiceXmlInterpreterContext context, FetchAttributes attributes, Grammar grammar) throws BadFetchError, UnsupportedFormatError, SemanticError, URISyntaxException {
        String scheme;
        URI src;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loading external grammar");
        }
        if ((src = this.getExternalUriSrc(grammar, context)).getFragment() != null) {
            LOGGER.warn("URI fragments are currently not supported: ignoring fragment");
            src = new URI(src.getScheme(), src.getUserInfo(), src.getHost(), src.getPort(), src.getPath(), src.getQuery(), null);
        }
        if ((scheme = src.getScheme()) != null && scheme.equalsIgnoreCase("builtin")) {
            DocumentServer server = context.getDocumentServer();
            src = server.resolveBuiltinUri(src);
        }
        LOGGER.info("loading grammar from source: '" + src + "'");
        FetchAttributes adaptedAttributes = this.adaptFetchAttributes(attributes, grammar);
        GrammarDocument document = context.acquireExternalGrammar(src, adaptedAttributes);
        if (document == null) {
            throw new BadFetchError("Unable to load grammar '" + src + "'!");
        }
        this.adaptGrammarAttributes(grammar, document);
        return document;
    }

    private void adaptGrammarAttributes(Grammar grammar, GrammarDocument document) {
        GrammarType type = grammar.getType();
        document.setMediaType(type);
        ModeType mode = grammar.getMode();
        if (mode == null) {
            mode = ModeType.VOICE;
        }
        document.setModeType(mode);
    }

    private URI getExternalUriSrc(Grammar grammar, VoiceXmlInterpreterContext context) throws URISyntaxException, SemanticError, BadFetchError {
        URI src = grammar.getSrcUri();
        if (src != null) {
            return src;
        }
        String srcexpr = grammar.getSrcexpr();
        if (srcexpr == null) {
            throw new BadFetchError("unable to resolve the external URI: neither a src nor a srcexpr found");
        }
        String unescapedSrcexpr = StringEscapeUtils.unescapeXml((String)srcexpr);
        DataModel model = context.getDataModel();
        String value = model.evaluateExpression(unescapedSrcexpr, String.class);
        if (value == null || value == model.getUndefinedValue()) {
            throw new URISyntaxException(unescapedSrcexpr, "srcexpr does not describe a valid uri");
        }
        return new URI(value);
    }

    private FetchAttributes adaptFetchAttributes(FetchAttributes docAttributes, Grammar grammar) {
        long maxStale;
        long maxAge;
        long fetchTimeout;
        FetchAttributes attributes = docAttributes == null ? new FetchAttributes() : new FetchAttributes(docAttributes);
        String fetchHint = grammar.getFetchhint();
        if (fetchHint != null) {
            attributes.setFetchHint(fetchHint);
        }
        if ((fetchTimeout = grammar.getFetchTimeoutAsMsec()) > 0L) {
            attributes.setFetchTimeout(fetchTimeout);
        }
        if ((maxAge = grammar.getMaxageAsMsec()) > 0L) {
            attributes.setMaxage(maxAge);
        }
        if ((maxStale = grammar.getMaxageAsMsec()) > 0L) {
            attributes.setMaxstale(maxStale);
        }
        return attributes;
    }
}

