/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;
import org.w3c.dom.Document;

public final class InternalGrammarDocument
implements GrammarDocument {
    private static final Logger LOGGER = LogManager.getLogger(InternalGrammarDocument.class);
    private static final int HASH_CODE_BASE = 13;
    private static final int HASH_CODE_MULTIPLIER = 31;
    private GrammarType type;
    private ModeType mode;
    private String document;
    private final String charset;
    private final byte[] buffer;
    private final Grammar grammar;
    private URI uri;

    public InternalGrammarDocument(Grammar node) {
        Document owner = node.getOwnerDocument();
        String ownerEncoding = owner.getInputEncoding();
        this.charset = ownerEncoding == null ? System.getProperty("file.encoding") : ownerEncoding;
        this.document = null;
        this.buffer = node.toString().getBytes();
        this.grammar = node;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public void setURI(URI value) {
        this.uri = value;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public GrammarType getMediaType() {
        return this.type;
    }

    @Override
    public void setMediaType(GrammarType grammartype) {
        this.type = grammartype;
    }

    @Override
    public boolean isAscii() {
        return true;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public String getDocument() {
        if (this.document == null) {
            if (this.charset == null) {
                this.document = new String(this.buffer);
            } else {
                try {
                    this.document = new String(this.buffer, this.charset);
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.warn("unable to use charset '" + this.charset + "' to convert grammar '" + this.uri + "'' Using default.", (Throwable)ex);
                    this.document = new String(this.buffer);
                }
            }
        }
        return this.document;
    }

    @Override
    public String getTextContent() {
        return this.grammar.getTextContent();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GrammarDocument)) {
            return false;
        }
        GrammarDocument other = (GrammarDocument)obj;
        return this.equals(other);
    }

    @Override
    public boolean equals(GrammarDocument other) {
        byte[] otherBuffer = other.getBuffer();
        return Arrays.equals(this.buffer, otherBuffer);
    }

    public int hashCode() {
        int prime = 31;
        return 403 + Arrays.hashCode(this.buffer);
    }

    @Override
    public ModeType getModeType() {
        return this.mode;
    }

    @Override
    public void setModeType(ModeType modeType) {
        this.mode = modeType;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getCanonicalName());
        str.append('[');
        str.append(this.uri);
        str.append(',');
        str.append(this.mode);
        str.append(',');
        str.append(this.type);
        str.append(',');
        str.append(this.charset);
        str.append(',');
        str.append(this.getDocument());
        str.append(']');
        return str.toString();
    }
}

