/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar;

import java.util.Collection;
import java.util.Locale;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.FetchAttributes;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.event.error.UnsupportedFormatError;
import org.jvoicexml.interpreter.GrammarProcessor;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.grammar.GrammarIdentifier;
import org.jvoicexml.interpreter.grammar.GrammarIdentifierCentral;
import org.jvoicexml.interpreter.grammar.GrammarLoader;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;

public final class JVoiceXmlGrammarProcessor
implements GrammarProcessor {
    private GrammarIdentifierCentral identifier = new GrammarIdentifierCentral();
    private final GrammarLoader loader = new GrammarLoader();

    @Override
    public void init(Configuration configuration) throws ConfigurationException {
        Collection<GrammarIdentifier> identifiers = configuration.loadObjects(GrammarIdentifier.class, "jvxmlgrammar");
        for (GrammarIdentifier current : identifiers) {
            this.identifier.addIdentifier(current);
        }
    }

    public void setGrammaridentifier(GrammarIdentifierCentral central) {
        this.identifier = central;
    }

    @Override
    public GrammarDocument process(VoiceXmlInterpreterContext context, FetchAttributes attributes, Grammar grammar, Locale language) throws NoresourceError, BadFetchError, UnsupportedFormatError, SemanticError {
        GrammarDocument document = this.loader.loadGrammarDocument(context, attributes, grammar, language);
        this.identifyGrammar(grammar, document);
        this.adaptMode(grammar, document);
        return document;
    }

    private GrammarDocument identifyGrammar(Grammar grammar, GrammarDocument document) throws UnsupportedFormatError {
        GrammarType expectedType;
        try {
            expectedType = grammar.getType();
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedFormatError(e.getMessage(), e);
        }
        GrammarType actualType = this.identifier.identifyGrammar(document, expectedType);
        if (actualType == null) {
            throw new UnsupportedFormatError(expectedType + " is not supported.");
        }
        document.setMediaType(actualType);
        return document;
    }

    private void adaptMode(Grammar grammar, GrammarDocument document) {
        ModeType mode = grammar.getMode();
        if (mode == null) {
            mode = ModeType.VOICE;
        }
        document.setModeType(mode);
    }
}

