/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar.identifier;

import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.interpreter.grammar.GrammarIdentifier;
import org.jvoicexml.xml.srgs.GrammarType;

public final class JsgfGrammarIdentifier
implements GrammarIdentifier {
    private static final Logger LOGGER = LogManager.getLogger(JsgfGrammarIdentifier.class);
    private static final String JSGF_HEDAER = "#JSGF";

    @Override
    public GrammarType identify(GrammarDocument grammar) {
        if (grammar == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("grammar is null or empty");
            }
            return null;
        }
        if (!grammar.isAscii()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("can only handle ascii grammars");
            }
            return null;
        }
        String document = grammar.getTextContent();
        if (document.startsWith(JSGF_HEDAER)) {
            return GrammarType.JSGF;
        }
        StringTokenizer tok = new StringTokenizer(document, ";");
        if (!tok.hasMoreTokens()) {
            return null;
        }
        String header = tok.nextToken();
        if (header.startsWith(JSGF_HEDAER)) {
            return GrammarType.JSGF;
        }
        return null;
    }

    @Override
    public GrammarType getSupportedType() {
        return GrammarType.JSGF;
    }
}

