/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar.identifier;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.interpreter.grammar.GrammarIdentifier;
import org.jvoicexml.xml.srgs.GrammarType;

public final class NuanceDynagramBinaryGrammarIdentifier
implements GrammarIdentifier {
    private static final Logger LOGGER = LogManager.getLogger(NuanceDynagramBinaryGrammarIdentifier.class);
    private static final String HEXES = "0123456789ABCDEF";
    private static final String EXPECTED_BINARY_HEADER = "EFA6A91500000200";

    @Override
    public GrammarType identify(GrammarDocument grammar) {
        if (grammar == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Grammar is null or empty");
            }
            return null;
        }
        if (grammar.isAscii()) {
            return null;
        }
        byte[] grammarInBytes = grammar.getBuffer();
        boolean isAccepted = this.identify(grammarInBytes);
        if (!isAccepted) {
            return null;
        }
        return GrammarType.GSL_BINARY;
    }

    private boolean identify(byte[] grammarInBytes) {
        if (grammarInBytes == null) {
            return false;
        }
        String realHeader = this.getFirstSeveralHexes(grammarInBytes, EXPECTED_BINARY_HEADER.length());
        return realHeader.equals(EXPECTED_BINARY_HEADER);
    }

    private String getFirstSeveralHexes(byte[] raw, int neededHexLength) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(neededHexLength);
        for (int i = 0; i < neededHexLength / 2; ++i) {
            byte b = raw[i];
            hex.append(HEXES.charAt((b & 0xF0) >> 4));
            hex.append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    @Override
    public GrammarType getSupportedType() {
        return GrammarType.GSL_BINARY;
    }
}

