/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.grammar.identifier;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.interpreter.grammar.GrammarIdentifier;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.SrgsXmlDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SrgsXmlGrammarIdentifier
implements GrammarIdentifier {
    private static final Logger LOGGER = LogManager.getLogger(SrgsXmlGrammarIdentifier.class);

    @Override
    public GrammarType identify(GrammarDocument grammar) {
        if (grammar == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("grammar is null or empty");
            }
            return null;
        }
        byte[] buffer = grammar.getBuffer();
        if (buffer == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("grammar buffer is null or empty");
            }
            return null;
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            InputSource input = new InputSource(stream);
            SrgsXmlDocument srgs = new SrgsXmlDocument(input);
            Grammar gr = srgs.getGrammar();
            if (gr == null) {
                return null;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found a SRGS XML grammar header.");
            }
            if (!this.isVersionCompliant(gr)) {
                return null;
            }
            if (!this.isModeCompliant(gr)) {
                return null;
            }
        }
        catch (ParserConfigurationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        catch (SAXException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        return GrammarType.SRGS_XML;
    }

    private boolean isVersionCompliant(Grammar grammar) {
        String version = grammar.getVersion();
        if (version == null) {
            LOGGER.warn("The version attribute has to be provided.");
            return false;
        }
        return "1.0".equals(version);
    }

    private boolean isModeCompliant(Grammar grammar) {
        if (ModeType.VOICE == grammar.getMode()) {
            if (grammar.getAttribute("xml:lang") == null) {
                LOGGER.warn("If mode is provided and equals voice, xml:lang has to be provided too!");
                return false;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xml:lang attribute provided, thx.");
            }
            Locale lang = new Locale(grammar.getXmlLang());
            LOGGER.info("locale is " + lang.getLanguage());
        }
        return true;
    }

    @Override
    public GrammarType getSupportedType() {
        return GrammarType.SRGS_XML;
    }
}

