/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopePublisher;
import org.jvoicexml.interpreter.scope.ScopeSubscriber;

public final class ScopeObserver
implements ScopePublisher {
    private static final Logger LOGGER = LogManager.getLogger(ScopeObserver.class);
    private final Collection<ScopeSubscriber> scopeSubscriber = new ArrayList<ScopeSubscriber>();
    private final Stack<Scope> scopes = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterScope(Scope scope) {
        if (scope == null) {
            LOGGER.warn("ignoring entered null scope");
            return;
        }
        LOGGER.info("entering new scope '" + scope.getName() + "'...");
        Scope previous = this.currentScope();
        this.scopes.push(scope);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("current scope stack: " + this.scopes);
        }
        Collection<ScopeSubscriber> collection = this.scopeSubscriber;
        synchronized (collection) {
            for (ScopeSubscriber listener : this.scopeSubscriber) {
                listener.enterScope(previous, scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitScope(Scope scope) {
        if (scope == null) {
            LOGGER.warn("ignoring exited null scope");
            return;
        }
        LOGGER.info("exiting scope '" + scope.getName() + "'...");
        int position = this.scopes.search((Object)scope);
        if (position < 0) {
            LOGGER.warn("mismatched scope order. cannot exit '" + scope.getName() + "'");
            LOGGER.warn("current scope stack: " + this.scopes);
            return;
        }
        for (int i = 0; i < position; ++i) {
            this.scopes.pop();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("current scope stack: " + this.scopes);
        }
        Scope previous = this.currentScope();
        Collection<ScopeSubscriber> collection = this.scopeSubscriber;
        synchronized (collection) {
            for (ScopeSubscriber listener : this.scopeSubscriber) {
                listener.exitScope(scope, previous);
            }
        }
    }

    public Scope currentScope() {
        if (this.scopes.empty()) {
            return null;
        }
        return this.scopes.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScopeSubscriber(ScopeSubscriber subscriber) {
        Collection<ScopeSubscriber> collection = this.scopeSubscriber;
        synchronized (collection) {
            this.scopeSubscriber.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeScopeSubscriber(ScopeSubscriber subscriber) {
        Collection<ScopeSubscriber> collection = this.scopeSubscriber;
        synchronized (collection) {
            this.scopeSubscriber.remove(subscriber);
        }
    }
}

