/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopeSubscriber;
import org.jvoicexml.interpreter.scope.ScopedCollectionItem;

public final class ScopedCollection<E>
implements ScopeSubscriber,
Collection<E> {
    private static final Logger LOGGER = LogManager.getLogger(ScopedCollection.class);
    private final Stack<ScopedCollectionItem<E>> stack = new Stack();
    private final Collection<E> view = new ArrayList();
    private boolean needRecreatedView;
    private final ScopeObserver observer;
    private Scope scope;

    public ScopedCollection(ScopeObserver scopeObserver) {
        if (scopeObserver != null) {
            this.observer = scopeObserver;
            this.observer.addScopeSubscriber(this);
            this.scope = this.observer.currentScope();
        } else {
            LOGGER.warn("no monitoring of scope transitions possible");
            this.observer = null;
            this.scope = null;
        }
    }

    public void close() {
        if (this.observer != null) {
            this.observer.removeScopeSubscriber(this);
        }
    }

    @Override
    public void enterScope(Scope previous, Scope next) {
        this.scope = next;
    }

    @Override
    public void exitScope(Scope previous, Scope next) {
        ScopedCollectionItem<E> item;
        if (!this.stack.isEmpty() && (item = this.stack.peek()).getScope() == previous) {
            this.stack.pop();
            this.view.removeAll(item);
        }
        this.scope = next;
    }

    private ScopedCollectionItem<E> getTopmostCollection() {
        ScopedCollectionItem<E> item = null;
        if (!this.stack.empty()) {
            item = this.stack.peek();
        }
        if (item == null) {
            item = new ScopedCollectionItem(this.scope);
            this.stack.push(item);
        } else if (item.getScope() != this.scope) {
            item = new ScopedCollectionItem(this.scope);
            this.stack.push(item);
        }
        return item;
    }

    private Collection<E> getView() {
        if (this.needRecreatedView) {
            this.view.clear();
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                ScopedCollectionItem item = (ScopedCollectionItem)this.stack.get(i);
                this.view.addAll(item);
            }
            this.needRecreatedView = false;
        }
        return this.view;
    }

    @Override
    public boolean add(E e) {
        this.needRecreatedView = true;
        ScopedCollectionItem<E> collection = this.getTopmostCollection();
        return collection.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.needRecreatedView = true;
        ScopedCollectionItem<? extends E> collection = this.getTopmostCollection();
        return collection.addAll(c);
    }

    @Override
    public void clear() {
        this.needRecreatedView = true;
        this.stack.clear();
    }

    @Override
    public boolean contains(Object o) {
        Collection<E> currentView = this.getView();
        return currentView.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Collection<E> currentView = this.getView();
        return currentView.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        Collection<E> currentView = this.getView();
        return currentView.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.view.iterator();
    }

    @Override
    public boolean remove(Object o) {
        for (ScopedCollectionItem scopedCollectionItem : this.stack) {
            if (!scopedCollectionItem.remove(o)) continue;
            this.needRecreatedView = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o) || changed) continue;
            this.needRecreatedView = true;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public int size() {
        Collection<E> currentView = this.getView();
        return currentView.size();
    }

    @Override
    public Object[] toArray() {
        Collection<E> currentView = this.getView();
        return currentView.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Collection<E> currentView = this.getView();
        return currentView.toArray(a);
    }
}

