/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopeSubscriber;
import org.jvoicexml.interpreter.scope.ScopedMapEntry;
import org.jvoicexml.interpreter.scope.ScopedMapItem;

public final class ScopedMap<K, V>
implements ScopeSubscriber,
Map<K, V> {
    private static final Logger LOGGER = LogManager.getLogger(ScopedMap.class);
    private final Map<K, Stack<ScopedMapItem<V>>> map = new HashMap<K, Stack<ScopedMapItem<V>>>();
    private final ScopeObserver observer;
    private Scope scope;

    public ScopedMap(ScopeObserver scopeObserver) {
        if (scopeObserver != null) {
            this.observer = scopeObserver;
            this.observer.addScopeSubscriber(this);
            this.scope = this.observer.currentScope();
        } else {
            LOGGER.warn("no monitoring of scope transitions possible");
            this.observer = null;
            this.scope = null;
        }
    }

    public void close() {
        if (this.observer != null) {
            this.observer.removeScopeSubscriber(this);
        }
    }

    @Override
    public void enterScope(Scope previous, Scope next) {
        this.scope = next;
    }

    @Override
    public void exitScope(Scope previous, Scope next) {
        Collection<Stack<ScopedMapItem<V>>> stacks = this.map.values();
        for (Stack<ScopedMapItem<V>> stack : stacks) {
            ScopedMapItem<V> item;
            if (stack.empty() || (item = stack.peek()).getScope() != previous) continue;
            stack.pop();
        }
        ArrayList<K> keysToRemove = new ArrayList<K>();
        for (Object key : this.map.keySet()) {
            Stack<ScopedMapItem<V>> stack = this.map.get(key);
            if (!stack.isEmpty()) continue;
            keysToRemove.add(key);
        }
        for (Object key : keysToRemove) {
            this.map.remove(key);
        }
        this.scope = next;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Stack<ScopedMapItem<V>> stack = this.map.get(key);
        if (stack == null) {
            return null;
        }
        if (stack.empty()) {
            return null;
        }
        ScopedMapItem<V> item = stack.peek();
        return item.getValue();
    }

    @Override
    public V put(K key, V value) {
        ScopedMapItem<Object> previousItem;
        Stack<ScopedMapItem<Object>> stack = this.map.get(key);
        if (stack == null) {
            stack = new Stack();
            this.map.put(key, stack);
            previousItem = null;
        } else {
            previousItem = stack.empty() ? null : stack.peek();
        }
        ScopedMapItem<V> item = new ScopedMapItem<V>(this.scope, value);
        stack.push(item);
        if (previousItem == null) {
            return null;
        }
        return (V)previousItem.getValue();
    }

    @Override
    public V remove(Object key) {
        Stack<ScopedMapItem<V>> stack = this.map.remove(key);
        if (stack == null) {
            return null;
        }
        if (stack.empty()) {
            return null;
        }
        ScopedMapItem<V> item = stack.peek();
        return item.getValue();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        Collection<Stack<ScopedMapItem<V>>> stacks = this.map.values();
        ArrayList<V> values = new ArrayList<V>();
        for (Stack<ScopedMapItem<V>> stack : stacks) {
            if (stack.empty()) continue;
            ScopedMapItem<V> item = stack.peek();
            V value = item.getValue();
            values.add(value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, Stack<ScopedMapItem<V>>>> entries = this.map.entrySet();
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Stack<ScopedMapItem<V>>> entry : entries) {
            K key = entry.getKey();
            ScopedMapEntry current = new ScopedMapEntry(key, this);
            set.add(current);
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

