/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.interpreter.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.interpreter.scope.Scope;
import org.jvoicexml.interpreter.scope.ScopeObserver;
import org.jvoicexml.interpreter.scope.ScopeSubscriber;
import org.jvoicexml.interpreter.scope.ScopedCollectionItem;
import org.jvoicexml.interpreter.scope.ScopedSetObserver;

public final class ScopedSet<E>
implements ScopeSubscriber,
Set<E> {
    private static final Logger LOGGER = LogManager.getLogger(ScopedSet.class);
    private final Stack<ScopedCollectionItem<E>> stack = new Stack();
    private final Set<E> view = new HashSet();
    private final ScopeObserver observer;
    private Scope scope;
    private final Collection<ScopedSetObserver<E>> observers = new ArrayList<ScopedSetObserver<E>>();

    public ScopedSet(ScopeObserver scopeObserver) {
        if (scopeObserver != null) {
            this.observer = scopeObserver;
            this.observer.addScopeSubscriber(this);
            this.scope = this.observer.currentScope();
        } else {
            LOGGER.warn("no monitoring of scope transitions possible");
            this.observer = null;
            this.scope = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScopedSetObserver(ScopedSetObserver<E> obs) {
        Collection<ScopedSetObserver<E>> collection = this.observers;
        synchronized (collection) {
            this.observers.add(obs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScopedSetObserver(ScopedSetObserver<E> obs) {
        Collection<ScopedSetObserver<E>> collection = this.observers;
        synchronized (collection) {
            this.observers.remove(obs);
        }
    }

    public void close() {
        if (this.observer != null) {
            this.observer.removeScopeSubscriber(this);
        }
    }

    @Override
    public void enterScope(Scope previous, Scope next) {
        this.scope = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitScope(Scope previous, Scope next) {
        ScopedCollectionItem<E> item;
        if (!this.stack.isEmpty() && (item = this.stack.peek()).getScope() == previous) {
            ArrayList<E> removed = new ArrayList<E>();
            removed.addAll(item);
            this.stack.pop();
            this.view.removeAll(removed);
            Collection<ScopedSetObserver<E>> collection = this.observers;
            synchronized (collection) {
                for (ScopedSetObserver obs : this.observers) {
                    obs.scopedSetChange(this, removed);
                }
            }
        }
        this.scope = next;
    }

    private ScopedCollectionItem<E> getCurrentCollection() {
        ScopedCollectionItem<E> item = null;
        if (!this.stack.empty()) {
            item = this.stack.peek();
        }
        if (item == null) {
            item = new ScopedCollectionItem(this.scope);
            this.stack.push(item);
        } else if (item.getScope() != this.scope) {
            item = new ScopedCollectionItem(this.scope);
            this.stack.push(item);
        }
        return item;
    }

    @Override
    public boolean add(E e) {
        if (this.view.contains(e)) {
            return false;
        }
        this.view.add(e);
        ScopedCollectionItem<E> collection = this.getCurrentCollection();
        return collection.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            modified = this.add(e) || modified;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.view.clear();
        this.stack.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.view.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.view.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.stack.empty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.view.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (!this.contains(o)) {
            return false;
        }
        this.view.remove(o);
        for (ScopedCollectionItem scopedCollectionItem : this.stack) {
            if (!scopedCollectionItem.remove(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o) || changed) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public int size() {
        return this.view.size();
    }

    @Override
    public Object[] toArray() {
        return this.view.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.view.toArray(a);
    }
}

